/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.FacilityImageConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.IFacility;
import com.clustercontrol.cloud.aws.presenter.IFacilityRoot;
import com.clustercontrol.cloud.aws.presenter.INode;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.composite.FacilityTreeComposite;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ScopeView
extends ViewPart {
    public static final String Id = "com.clustercontrol.cloud.ui.views.ScopeView";
    private AllPropertyObserver observer = new AllPropertyObserver(){

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            if (event.getAddedElement() instanceof IElement) {
                ((IElement)event.getAddedElement()).addPropertyObserver2(IElement.allProperty, this);
            }
            ScopeView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScopeView.this.treeViewer.refresh(true);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            if (event.getRemovedElement() instanceof IElement) {
                ((IElement)event.getRemovedElement()).removePropertyObserver2(IElement.allProperty, this);
            }
            ScopeView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScopeView.this.treeViewer.refresh(true);
                }
            });
        }

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            ScopeView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ScopeView.this.treeViewer.refresh(true);
                }
            });
        }
    };
    private FacilityRootUpdateService service;
    private TreeViewer treeViewer;
    private IFacilityRoot input;
    private Composite composite;

    public void createPartControl(Composite arg0) {
        this.composite = new Composite(arg0, 0);
        this.composite.setLayout((Layout)new FillLayout(256));
        Composite composite_1 = new Composite(this.composite, 0);
        TreeColumnLayout tcl_composite = new TreeColumnLayout();
        composite_1.setLayout((Layout)tcl_composite);
        this.treeViewer = new TreeViewer(composite_1, 2816);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IScope) {
                    return FacilityImageConstant.typeToImage((int)0);
                }
                if (element instanceof INode) {
                    return FacilityImageConstant.typeToImage((int)1);
                }
                return FacilityImageConstant.typeToImage((int)1);
            }

            public String getText(Object element) {
                if (element instanceof IFacility) {
                    IFacility facility = (IFacility)element;
                    return facility.getName() + "(" + facility.getFacilityId() + ")";
                }
                return null;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.update();
    }

    private void setUp(IFacilityRoot faciiltyRoot) {
        faciiltyRoot.addPropertyObserver2(IElement.allProperty, this.observer);
        for (IScope scope : faciiltyRoot.getScopes()) {
            this.recursiveSetUp(scope);
        }
    }

    private void recursiveSetUp(IScope scope) {
        scope.addPropertyObserver2(IElement.allProperty, this.observer);
        for (IScope iScope : scope.getScopes()) {
            this.recursiveSetUp(iScope);
        }
        for (IFacility iFacility : scope.getNodes()) {
            iFacility.addPropertyObserver2(IElement.allProperty, this.observer);
        }
    }

    private void setDown(IFacilityRoot faciiltyRoot) {
        faciiltyRoot.removePropertyObserver2(IElement.allProperty, this.observer);
        for (IScope scope : faciiltyRoot.getScopes()) {
            this.recursiveSetDown(scope);
        }
    }

    private void recursiveSetDown(IScope scope) {
        scope.removePropertyObserver2(IElement.allProperty, this.observer);
        for (IScope iScope : scope.getScopes()) {
            this.recursiveSetDown(iScope);
        }
        for (IFacility iFacility : scope.getNodes()) {
            iFacility.removePropertyObserver2(IElement.allProperty, this.observer);
        }
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void dispose() {
        if (this.service != null) {
            this.service.dispose();
        }
        if (this.input != null) {
            this.setDown(this.input);
        }
        Activator.getDefault().releaseCloudManager();
        super.dispose();
    }

    public void update() {
        if (this.input == null) {
            try {
                this.input = Activator.getDefault().getCloudManager().getHinemosService().getFacilityRoot();
                if (this.input != null) {
                    this.setUp(this.input);
                    this.treeViewer.setInput((Object)this.input);
                    this.treeViewer.expandToLevel(2);
                    this.service = new FacilityRootUpdateService();
                }
            }
            catch (CloudModelException e) {
                Logger logger = Logger.getLogger(ScopeView.class);
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                this.input.update();
            }
            catch (CloudModelException e) {
                if ("FacilityRoot.InvalidRootScope.NotFound".equals(e.getErrorCode())) {
                    this.setDown(this.input);
                    this.input = null;
                    this.treeViewer.setInput(null);
                    this.service.dispose();
                    this.service = null;
                }
                Logger logger = Logger.getLogger(ScopeView.class);
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private class TreeContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IScope) {
                IScope scope = (IScope)parentElement;
                ArrayList<IFacility> facilities = new ArrayList<IFacility>();
                facilities.addAll(Arrays.asList(scope.getScopes()));
                facilities.addAll(Arrays.asList(scope.getNodes()));
                return facilities.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IFacility) {
                IFacility facility = (IFacility)element;
                return facility.getParent() != null ? facility.getParent() : facility.getFacilityRoot();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IScope) {
                IScope scope = (IScope)element;
                return scope.getScopes().length != 0 || scope.getNodes().length != 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IFacilityRoot) {
                return ((IFacilityRoot)inputElement).getScopes();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FacilityRootUpdateService {
        private FacilityTreeComposite listener;

        public FacilityRootUpdateService() {
            this.listener = new FacilityTreeComposite(ScopeView.this.composite, 0){

                public void update() {
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ScopeView.this.input == null) {
                                return;
                            }
                            ScopeView.this.update();
                        }
                    });
                }

                public boolean isDisposed() {
                    return false;
                }
            };
            this.listener.dispose();
            new FacilityTree().addComposite(this.listener);
        }

        public void dispose() {
            new FacilityTree().delComposite(this.listener);
        }
    }
}

