/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IStorageRoot;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.aws.presenter.StorageRoot;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.FilterlingViewPartByScopeTree;
import com.clustercontrol.cloud.ui.views.FooterComposite;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudStorage;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;

public class StoragesView2
extends FilterlingViewPartByScopeTree<IStorageRoot, IStorage, CloudStorage>
implements ISelectionListener {
    public static final String Id = "com.clustercontrol.cloud.ui.views.StoragesView2";
    private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
    private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
    private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
    private Label lblHeader;
    private FooterComposite footerComposite;
    private Table table;
    private TableViewer tableViewer;

    public void createPartControl(Composite arg0) {
        Composite composite = new Composite(arg0, 0);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        this.lblHeader = new Label(composite, 0);
        this.lblHeader.setSize(this.lblHeader.getSize().x, 80);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblHeader.setLayoutData((Object)gridData);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn.setText(this.bundle_view_label.getString("view.storage.column.storage_id"));
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getStorageId();
            }
        });
        TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_7, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_7.setText(this.bundle_view_label.getString("view.storage.column.storage_name"));
        tableViewerColumn_7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getStorageName();
            }
        });
        TableViewerColumn tableViewerColumn_11 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_11 = tableViewerColumn_11.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_11, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_11.setText(this.bundle_view_label.getString("view.storage.column.cloud_id"));
        tableViewerColumn_11.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getCloudId();
            }
        });
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_1, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_1.setText(this.bundle_view_label.getString("view.storage.column.status"));
        tableViewerColumn_1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStorage storage = (IStorage)element;
                return storage.getState() != null ? storage.getState() : null;
            }
        });
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
        tblclmnNewColumn_2.setText(this.bundle_view_label.getString("view.storage.column.create_time"));
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_2, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tableViewerColumn_2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStorage storage = (IStorage)element;
                return storage.getStorageAttachment() != null ? StoragesView2.this.format.format(storage.getStorageAttachment().getAttachTime()) : null;
            }
        });
        TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_3, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_3.setText(this.bundle_view_label.getString("view.storage.column.attached_instance"));
        tableViewerColumn_3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStorage storage = (IStorage)element;
                return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getInstanceId() : null;
            }
        });
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_5, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_5.setText(this.bundle_view_label.getString("view.storage.column.volume_type"));
        tableViewerColumn_5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStorage storage = (IStorage)element;
                return storage.getStorageKind() != null ? StoragesView2.this.bundle_volume_type.getString(storage.getStorageKind()) : null;
            }
        });
        TableViewerColumn tableViewerColumn_17 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_17 = tableViewerColumn_17.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_17, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_17.setText(this.bundle_view_label.getString("view.storage.column.facility_id"));
        tableViewerColumn_17.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getFacilityId();
            }
        });
        TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_4, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_4.setText(this.bundle_view_label.getString("view.storage.column.facility_name"));
        tableViewerColumn_4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getFacilityName();
            }
        });
        TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_6, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_6.setText(this.bundle_view_label.getString("view.storage.column.size"));
        tableViewerColumn_6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStorage storage = (IStorage)element;
                return storage.getSize() != null ? storage.getSize().toString() : null;
            }
        });
        TableViewerColumn tableViewerColumn_9 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_9 = tableViewerColumn_9.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_9, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_9.setText(this.bundle_view_label.getString("view.storage.column.availability_zone"));
        tableViewerColumn_9.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getAvailabilityZone();
            }
        });
        TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_8, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_8.setText(this.bundle_view_label.getString("view.storage.column.region"));
        tableViewerColumn_8.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String regionName = StoragesView2.this.bundle_region.getString(((IStorage)element).getRegion().getRegionName());
                return regionName != null ? regionName : ((IStorage)element).getRegion().getRegionName();
            }
        });
        TableViewerColumn tableViewerColumn_10 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_10 = tableViewerColumn_10.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_10, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_10.setText(this.bundle_view_label.getString("view.storage.column.regist_state"));
        tableViewerColumn_10.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getRegistState().name();
            }
        });
        TableViewerColumn tableViewerColumn_16 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_16 = tableViewerColumn_16.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_16, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_16.setText(this.bundle_view_label.getString("view.storage.column.tags"));
        tableViewerColumn_16.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IStorage storage = (IStorage)element;
                String tags = null;
                if (!storage.getTags().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < storage.getTags().size(); ++i) {
                        IStorage.Tag tag = storage.getTags().get(i);
                        sb.append(tag.getName()).append("=").append(tag.getValue());
                        if (i == storage.getTags().size() - 1) continue;
                        sb.append("; ");
                    }
                    tags = sb.toString();
                } else {
                    tags = "";
                }
                return tags;
            }
        });
        TableViewerColumn tableViewerColumn_12 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_12 = tableViewerColumn_12.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_12, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_12.setText(this.bundle_view_label.getString("view.storage.column.reg_date"));
        tableViewerColumn_12.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getRegDate() != null ? StoragesView2.this.format.format(((IStorage)element).getRegDate()) : null;
            }
        });
        TableViewerColumn tableViewerColumn_13 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_13 = tableViewerColumn_13.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_13, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_13.setText(this.bundle_view_label.getString("view.storage.column.update_date"));
        tableViewerColumn_13.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getUpdateDate() != null ? StoragesView2.this.format.format(((IStorage)element).getUpdateDate()) : null;
            }
        });
        TableViewerColumn tableViewerColumn_14 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_14 = tableViewerColumn_14.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_14, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_14.setText(this.bundle_view_label.getString("view.storage.column.reg_user"));
        tableViewerColumn_14.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getRegUser() != null ? ((IStorage)element).getRegUser() : null;
            }
        });
        TableViewerColumn tableViewerColumn_15 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumn_15 = tableViewerColumn_15.getColumn();
        tcl_composite_1.setColumnData((Widget)tblclmnNewColumn_15, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnNewColumn_15.setText(this.bundle_view_label.getString("view.storage.column.update_user"));
        tableViewerColumn_15.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IStorage)element).getUpdateUser() != null ? ((IStorage)element).getUpdateUser() : null;
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.footerComposite = new FooterComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.footerComposite.setSize(this.lblHeader.getSize().x, 80);
        this.footerComposite.setLayoutData(gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.update();
    }

    @Override
    protected IStorageRoot getRootElement(IRegion region) {
        return region.getStorageRoot();
    }

    @Override
    protected List<IStorage> getElements(IStorageRoot root) {
        return Arrays.asList(root.getStorages());
    }

    @Override
    protected PropertyId2<CollectionObserver2<IStorage>> getPropertyId() {
        return IStorageRoot.p2.storages;
    }

    @Override
    protected boolean isMatchRegion(IRegion region, IStorage element) {
        return element.getRegion() == region;
    }

    @Override
    protected boolean isMatchAvailabilityZone(String zoneName, IStorage element) {
        return zoneName.equals(element.getAvailabilityZone());
    }

    @Override
    protected boolean isMatchFacilityId(String facilityId, IStorage element) {
        return facilityId.equals(element.getFacilityId());
    }

    @Override
    protected Label getHeaderLabel() {
        return this.lblHeader;
    }

    @Override
    protected Label getLeftFooter() {
        return this.footerComposite.getLeftControl();
    }

    @Override
    protected Label getRightFooter() {
        return this.footerComposite.getRightControl();
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    @Override
    protected List<CloudStorage> getManagerElements(CloudEndpoint endpoint, IRegion region) throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
        return endpoint.getStoragesByRegion(region.getRegionName());
    }

    @Override
    protected void setManagerElements(IStorageRoot rootElement, List<CloudStorage> managerElements) {
        ((StorageRoot)rootElement).internalUpdate(managerElements);
    }

    @Override
    protected boolean isInitialized(IStorageRoot rootElement) {
        return ((StorageRoot)rootElement).isInitialized();
    }

    @Override
    protected ThreadPoolExecutor getExecutor() {
        return threadPool;
    }
}

