/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.aws.presenter.CreateStorageBackupRequest;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageBackupDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class BackupStorageAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.BackupStorage";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IStorage storage = (IStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        CreateStorageBackupDialog dialog = new CreateStorageBackupDialog(this.viewPart.getSite().getShell(), storage);
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_snapshot_confirm"))) {
                CreateStorageBackupRequest request = new CreateStorageBackupRequest();
                request.setSnapshotName(dialog.getName());
                request.setDescription(dialog.getDescription());
                request.setStorageId(storage.getStorageId());
                request.setRegion(storage.getRegion().getRegionName());
                storage.getStorageRoot().getRegion().getBackupManagement().getStorageBackupRoot().createStorageBackup(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_snapshot_result"));
            } else {
                return;
            }
        }
    }
}

