/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

public class CreateInstanceAction
extends AbstractViewAction {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateInstanceAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) throws InvocationException {
        final ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
        IEC2Service service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        InstancesView2 view = (InstancesView2)this.viewPart;
        IRegion region = view.getActiveRegion();
        if (region != null) {
            CreateInstanceDialog.Model m = new CreateInstanceDialog.Model();
            m.regionName = region.getRegionName();
            if (view.getActiveZone() != null) {
                m.availabilityZone = new AvailabilityZone();
                m.availabilityZone.setZoneName(view.getActiveZone());
            }
            dialog.setInput(m);
        }
        CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){
            private Combo region;

            @Override
            public void setupRegion(Combo region) {
                for (String regionName : this.provider.getAllRegion()) {
                    String regionLocaleName = this.bundle_region.getString(regionName);
                    region.add(regionLocaleName);
                    region.setData(regionLocaleName, (Object)regionName);
                }
                if (this.input != null && this.input.regionName != null) {
                    String regionLocaleName = this.bundle_region.getString(this.input.regionName);
                    region.select(region.indexOf(regionLocaleName));
                } else {
                    region.select(0);
                }
                this.region = region;
            }

            @Override
            public void setupAvailabilityZone(Combo availabilityZone) {
            }

            @Override
            public void setupKeyPair(Combo keyPair) {
            }

            @Override
            public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
                rdoAmi.setSelection(true);
                rdoTemplate.setSelection(false);
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                for (ITemplate tmpTemplate : templateManagement.getTemplates()) {
                    if (!tmpTemplate.getRegion().equals(this.region.getData(this.region.getText()))) continue;
                    String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                    template.add(tmpLabel);
                    template.setData(tmpLabel, (Object)tmpTemplate);
                }
                template.setEnabled(false);
                editArgument.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_instance_confirm"))) {
                CreateInstanceDialog.Model m = dialog.getOutput();
                IRegion r = service.getRegion(m.regionName);
                final IInstance instance = m.isTemplateUsed != false ? r.getInstanceRoot().createInstance(m, m.templateId, m.arguments) : r.getInstanceRoot().createInstance(m);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_instance_result"));
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, IInstance.StateType.running, IInstance.StateType.terminated, IInstance.StateType.stopped);
                        FacilityTree.reflesh();
                    }
                });
            } else {
                return;
            }
        }
    }
}

