/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.INode;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Combo;

public class CreateTemplateAction
extends AbstractViewAction {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateTemplateAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
    private CloudResourceProvider provider = new CloudResourceProviderImpl(this.endpoint);
    private IRegion region;

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IStructuredSelection structuredSelection;
        IEC2Service ec2Service;
        ISelection selection = this.viewPart.getSite().getPage().getSelection("com.clustercontrol.cloud.ui.views.ScopeView");
        try {
            ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            Object selected = structuredSelection.getFirstElement();
            String facilityId = null;
            if (selected instanceof IScope) {
                IScope scope = (IScope)selected;
                switch (scope.getScopeType()) {
                    case root: {
                        break;
                    }
                    case region: {
                        facilityId = scope.getFacilityId();
                        break;
                    }
                    case availabilityZone: {
                        facilityId = scope.getParent().getFacilityId();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            } else if (selected instanceof INode) {
                INode node = (INode)selected;
                facilityId = node.getParent().getParent().getFacilityId();
            }
            if (facilityId != null) {
                this.region = ec2Service.getRegion(facilityId);
            }
        }
        CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(this.provider);
        try {
            dialog.setBehavior(new CreateTemplateDialog.DialogBehavior(){
                private MessageManager bundle_region = MessageManager.getInstance("region");
                private List<TemplateJobUtil.TemplateJobnet> templateJobs;
                private IRegion region;
                {
                    try {
                        this.templateJobs = TemplateJobUtil.getTemplateJobList(true);
                    }
                    catch (InvalidRole_Exception e) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
                        this.templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
                    }
                    this.region = CreateTemplateAction.this.region;
                }

                @Override
                public void setupRegion(Combo region) {
                    for (String regionName : CreateTemplateAction.this.provider.getAllRegion()) {
                        String regionLocaleName = this.bundle_region.getString(regionName);
                        region.add(regionLocaleName);
                        region.setData(regionLocaleName, (Object)regionName);
                    }
                    if (this.region != null) {
                        String regionLocaleName = this.bundle_region.getString(this.region.getRegionName());
                        region.select(region.indexOf(regionLocaleName));
                    } else {
                        region.select(0);
                    }
                }

                @Override
                public void setupLaunchJobId(Combo launchJobId) {
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        launchJobId.add(jobName);
                        launchJobId.setData(jobName, (Object)jobId);
                    }
                }

                @Override
                public void setupStartJobId(Combo startJobId) {
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        startJobId.add(jobName);
                        startJobId.setData(jobName, (Object)jobId);
                    }
                }

                @Override
                public void setupStopJobId(Combo stopJobId) {
                    for (TemplateJobUtil.TemplateJobnet childJobItem : this.templateJobs) {
                        String jobId = childJobItem.getJobnetId();
                        String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        stopJobId.add(jobName);
                        stopJobId.setData(jobName, (Object)jobId);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_template_confirm"))) {
                ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
                templateManagement.createTemplate(dialog.getOutput());
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_template_result"));
            } else {
                return;
            }
        }
    }
}

