/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.KeyCodec;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.ShowWindowsPasswordDialog;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;

public class GetWindowsPassAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.GetWindowsPassAction";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected boolean canEnabled(IStructuredSelection selection) {
        IInstance instance = (IInstance)selection.getFirstElement();
        return "WINDOWS".equals(instance.getPlatform());
    }

    @Override
    protected void invoke(IAction action) throws InvocationException {
        IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.get_password_confirm"))) {
            CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
            String password = null;
            try {
                password = endpoint.getWindowsPassword(instance.getRegion().getRegionName(), instance.getInstanceId());
            }
            catch (Exception e) {
                throw new InvocationException(e);
            }
            FileDialog dialog = new FileDialog(this.viewPart.getSite().getShell());
            String[] exts = new String[]{"*.pem"};
            String[] filterNames = new String[]{this.bundle_messages.getString("views.actions.get_password_secret_key_file") + "(" + "*.pem" + ")"};
            dialog.setFilterExtensions(exts);
            dialog.setFilterNames(filterNames);
            String file = dialog.open();
            try {
                KeyCodec codec = new KeyCodec();
                codec.setPrivateKeyFile(file);
                String decryptedPassword = new String(codec.decryptWithPrivateKey(KeyCodec.getBase64Binary(password)));
                if (decryptedPassword == null || decryptedPassword.isEmpty()) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("views.actions.get_password_secret_key_file_different"));
                    return;
                }
                ShowWindowsPasswordDialog swpDialog = new ShowWindowsPasswordDialog(this.viewPart.getSite().getShell());
                swpDialog.setText(decryptedPassword);
                swpDialog.open();
            }
            catch (Exception e) {
                throw new InvocationException(e);
            }
        }
    }
}

