/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceBackup;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class RestoreInstanceAction
extends SingleSelectionActionEx {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RestoreInstance";
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog dialog = new CreateInstanceDialog(this.viewPart.getSite().getShell());
        IInstanceBackup backup = (IInstanceBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        String region = backup.getRegion();
        if (region != null) {
            CreateInstanceDialog.Model m = new CreateInstanceDialog.Model();
            m.regionName = region;
            m.availabilityZone = new AvailabilityZone();
            m.availabilityZone.setZoneName(backup.getAvailabilityZone());
            m.facilityId = backup.getFacilityId();
            m.facilityName = backup.getFacilityName();
            m.keyName = backup.getKeyName();
            m.nodeName = backup.getNodeName();
            m.replaceNode = true;
            m.image = new Image();
            m.image.setImageId(backup.getImageId());
            m.image.setName(backup.getImageName());
            m.description = backup.getDescription();
            dialog.setInput(m);
        }
        CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
        dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
        dialog.setBehavior(new CreateInstanceDialog.DialogBehavior(){

            @Override
            public void setupFacilityId(Text facilityId) {
                facilityId.setText(this.input.facilityId);
            }

            @Override
            public void setupFacilityName(Text facilityName) {
                if (this.input.facilityName != null) {
                    facilityName.setText(this.input.facilityName);
                }
            }

            @Override
            public void setupReplaceNode(Button btnReplaceNode) {
                btnReplaceNode.setSelection(true);
            }

            @Override
            public void setupDescription(Text description) {
                if (this.input.description != null) {
                    description.setText(this.input.description);
                }
            }

            @Override
            public void setupNodeName(Text nodeName) {
                nodeName.setText(this.input.nodeName);
            }

            @Override
            public void setupRegion(Combo region) {
                String regionLocaleName = this.bundle_region.getString(this.input.regionName);
                region.add(regionLocaleName);
                region.setData(regionLocaleName, (Object)this.input.regionName);
                region.select(0);
                region.setEnabled(false);
            }

            @Override
            public void setupAvailabilityZone(Combo availabilityZone) {
                for (AvailabilityZone zone : this.provider.getAvailabilityZones(this.input.regionName)) {
                    availabilityZone.add(zone.getZoneName());
                }
                if (availabilityZone.indexOf(this.input.availabilityZone.getZoneName()) != -1) {
                    availabilityZone.select(availabilityZone.indexOf(this.input.availabilityZone.getZoneName()));
                } else {
                    availabilityZone.select(0);
                }
            }

            @Override
            public void setupKeyPair(Combo keyPair) {
                for (String keyName : this.provider.getKeyNames(this.input.regionName)) {
                    keyPair.add(keyName);
                }
                if (keyPair.getItemCount() > 0) {
                    if (keyPair.indexOf(this.input.keyName) != -1) {
                        keyPair.select(keyPair.indexOf(this.input.keyName));
                    } else {
                        keyPair.select(0);
                    }
                    keyPair.setEnabled(true);
                } else {
                    keyPair.setEnabled(false);
                }
            }

            @Override
            public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
                rdoAmi.setSelection(true);
                rdoAmi.setEnabled(false);
                rdoTemplate.setSelection(false);
                rdoTemplate.setEnabled(false);
            }

            @Override
            public void setupAmi(Text ami, Button selectAmi) {
                ami.setText("(" + this.input.image.getImageId() + ") " + this.input.image.getName());
                ami.setData((Object)this.input.image);
                ami.setEditable(false);
                selectAmi.setEnabled(false);
            }

            @Override
            public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
                useTemplate.setEnabled(false);
                template.setEnabled(false);
                editArgument.setEnabled(false);
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.bundle_messages.getString("views.actions.create_instance_confirm"))) {
                CreateInstanceDialog.Model m = dialog.getOutput();
                IRegion r = backup.getInstanceBackupRoot().getBackupManagement().getRegion();
                final IInstance instance = r.getInstanceRoot().restore(m);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.bundle_messages.getString("views.actions.create_instance_result"));
                this.viewPart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, IInstance.StateType.running, IInstance.StateType.terminated, IInstance.StateType.stopped);
                        FacilityTree.reflesh();
                    }
                });
            } else {
                return;
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        IInstanceBackup backup = (IInstanceBackup)((IStructuredSelection)selection).getFirstElement();
        if (backup == null || backup.getExistsStatus() == null || backup.getExistsStatus() == IInstanceBackup.ExistStatusType.nothing) {
            action.setEnabled(false);
        }
    }
}

