/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

public class AuthorizeIpPermissionRequest {
	private String SecurityGroupId;
	private String ipProtocol;
	private int fromPort;
	private int toPort;
	private String ipRange;
	private String sourceSecurityGroupId;
	private String userId;
	private String sourceSecurityGroupName;
	
	public AuthorizeIpPermissionRequest(){
		
	}

	public AuthorizeIpPermissionRequest(IIpPermission ipPermission){
		ipProtocol = ipPermission.getIpProtocol();
		fromPort = ipPermission.getFromPort();
		toPort = ipPermission.getToPort();
		ipRange = ipPermission.getIpRange();
		sourceSecurityGroupId = ipPermission.getSecurityGroupId();
		userId = ipPermission.getUserId();
		sourceSecurityGroupName = ipPermission.getGroupName();
	}
	
	public String getSecurityGroupId() {
		return SecurityGroupId;
	}
	public void setSecurityGroupId(String securityGroupId) {
		SecurityGroupId = securityGroupId;
	}
	public String getIpProtocol() {
		return ipProtocol;
	}
	public void setIpProtocol(String ipProtocol) {
		this.ipProtocol = ipProtocol;
	}
	public int getFromPort() {
		return fromPort;
	}
	public void setFromPort(int fromPort) {
		this.fromPort = fromPort;
	}
	public int getToPort() {
		return toPort;
	}
	public void setToPort(int toPort) {
		this.toPort = toPort;
	}
	public String getIpRange() {
		return ipRange;
	}
	public void setIpRange(String ipRange) {
		this.ipRange = ipRange;
	}
	public String getSrouceSecurityGroupId() {
		return sourceSecurityGroupId;
	}
	public void setSrouceSecurityGroupId(String sourceSecurityGroupId) {
		this.sourceSecurityGroupId = sourceSecurityGroupId;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public String getSourceSecurityGroupName() {
		return sourceSecurityGroupName;
	}
	public void setSourceSecurityGroupName(String sourceSecurityGroupName) {
		this.sourceSecurityGroupName = sourceSecurityGroupName;
	}
}
