/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;
import java.util.List;

import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.notify.NotifyRelationInfo;

public class BillingAlarm extends Element implements IBillingAlarm {
	private BillingAlarmService service;
	
	private String alarmId;
    private String alarmName;
    private String application;
    private String cloudId;
    private String cloudUserId;
    private String description;
    private String notifyGroupId;
    private List<NotifyRelationInfo> notifyRelationInfos;
    private String target;
    private Double thresholdInfoLimit;
    private Double thresholdWarnLimit;
    private Boolean validFlg;

    private Date regDate;
    private Date updateDate;
    private String regUser;
    private String updateUser;

    public BillingAlarm(BillingAlarmService service) {
    	this.service = service;
    }
    
	public CloudResourceManager getCloudResourceManager() {
		return getBillingAlarmService().getCloudResourceManager();
	}

	@Override
	public BillingAlarmService getBillingAlarmService() {
		return service;
	}

	@Override
    public String getAlarmId() {
		return alarmId;
	}
	public void setAlarmId(String alarmId) {
		this.alarmId = alarmId;
	}
	@Override
	public String getAlarmName() {
		return alarmName;
	}
	public void setAlarmName(String alarmName) {
		internalSet("alarmName", p2.alarmName, alarmName);
	}
	@Override
	public String getApplication() {
		return application;
	}
	public void setApplication(String application) {
		this.application = application;
	}
	@Override
	public String getCloudId() {
		return cloudId;
	}
	public void setCloudId(String cloudId) {
		this.cloudId = cloudId;
	}
	@Override
	public String getCloudUserId() {
		return cloudUserId;
	}
	public void setCloudUserId(String cloudUserId) {
		this.cloudUserId = cloudUserId;
	}
	@Override
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		internalSet("description", p2.description, description);
	}
	@Override
	public String getNotifyGroupId() {
		return notifyGroupId;
	}
	public void setNotifyGroupId(String notifyGroupId) {
		this.notifyGroupId = notifyGroupId;
	}
	@Override
	public List<NotifyRelationInfo> getNotifyRelationInfos() {
		return notifyRelationInfos;
	}
	public void setNotifyRelationInfos(List<NotifyRelationInfo> notifyRelationInfos) {
		this.notifyRelationInfos = notifyRelationInfos;
	}
	@Override
	public String getTarget() {
		return target;
	}
	public void setTarget(String target) {
		this.target = target;
	}
	@Override
	public Double getThresholdInfoLimit() {
		return thresholdInfoLimit;
	}
	public void setThresholdInfoLimit(Double thresholdInfoLimit) {
		internalSet("thresholdInfoLimit", p2.thresholdInfoLimit, thresholdInfoLimit);
	}
	@Override
	public Double getThresholdWarnLimit() {
		return thresholdWarnLimit;
	}
	public void setThresholdWarnLimit(Double thresholdWarnLimit) {
		internalSet("thresholdWarnLimit", p2.thresholdWarnLimit, thresholdWarnLimit);
	}
	@Override
	public Boolean getValidFlg() {
		return validFlg;
	}
	public void setValidFlg(Boolean validFlg) {
		internalSet("validFlg", p2.validFlg, validFlg);
	}
	@Override
	public Date getRegDate() {
		return regDate;
	}
	public void setRegDate(Date regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}
	@Override
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		internalSet("updateDate", p2.updateDate, updateDate);
	}
	@Override
	public String getRegUser() {
		return regUser;
	}
	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}
	@Override
	public String getUpdateUser() {
		return updateUser;
	}
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}
	@Override
	public void modify(ModifyBillingAlarmRequest request) {
		try {
			com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
			ba.setAlarmId(this.getAlarmId());
			ba.setAlarmName(request.getAlarmName());
//			ba.setApplication(BillingAlarmService.APPLICATION);
//			ba.setCloudId(this.getCloudId());
//			ba.setCloudUserId(this.getCloudUserId());
			ba.setDescription(request.getDescription());
			ba.setNotifyGroupId(this.getNotifyGroupId());
			ba.setTarget(request.getTarget());
			ba.setThresholdInfoLimit(request.getThresholdInfoLimit());
			ba.setThresholdWarnLimit(request.getThresholdWarnLimit());
			ba.setValidFlg(request.isValidFlg());
			ba.getNotifyRelationInfos().addAll(request.getNotifyRelationInfos());
			
			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			com.clustercontrol.ws.cloud.BillingAlarm wsBa = ce.modifyBillingAlarm(ba);
			overwriteByBillingAlarm(wsBa);
		}
		catch (CloudModelException e) {
			throw e;
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	@Override
	public void enableAlarm() {
		try {
			com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
			ba.setAlarmId(this.getAlarmId());
			ba.setValidFlg(true);
			CloudEndpoint ce = this.getBillingAlarmService().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			ce.modifyBillingAlarm(ba);
			setValidFlg(true);
		}
		catch (CloudModelException e) {
			throw e;
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	@Override
	public void disableAlarm() {
		try {
			com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
			ba.setAlarmId(this.getAlarmId());
			ba.setValidFlg(false);
			CloudEndpoint ce = this.getBillingAlarmService().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			ce.modifyBillingAlarm(ba);
			setValidFlg(false);
		}
		catch (CloudModelException e) {
			throw e;
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void update() throws InvalidStateException {
		try {
			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			com.clustercontrol.ws.cloud.BillingAlarm newBa = ce.getBillingAlarm(this.getAlarmId());
			this.internalUpdate(newBa);
		}
		catch (CloudModelException e) {
			throw e;
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	public void internalUpdate(com.clustercontrol.ws.cloud.BillingAlarm billingAlarm) {
		overwriteByBillingAlarm(billingAlarm);
		super.update();
	}
	
	protected void overwriteByBillingAlarm(com.clustercontrol.ws.cloud.BillingAlarm billingAlarm) {
		setAlarmId(billingAlarm.getAlarmId());
		setAlarmName(billingAlarm.getAlarmName());
		setApplication(billingAlarm.getApplication());
		setCloudId(billingAlarm.getCloudId());
		setCloudUserId(billingAlarm.getCloudUserId());
		setDescription(billingAlarm.getDescription());
		setNotifyGroupId(billingAlarm.getNotifyGroupId());
		setNotifyRelationInfos(billingAlarm.getNotifyRelationInfos());
		setTarget(billingAlarm.getTarget());
		setThresholdInfoLimit(billingAlarm.getThresholdInfoLimit());
		setThresholdWarnLimit(billingAlarm.getThresholdWarnLimit());
		setValidFlg(billingAlarm.isValidFlg());
		setRegDate(billingAlarm.getRegDate() != null ? new Date(billingAlarm.getRegDate()): null);
		setUpdateDate(billingAlarm.getUpdateDate() != null ? new Date(billingAlarm.getUpdateDate()): null);
		setRegUser(billingAlarm.getRegUser());
		setUpdateUser(billingAlarm.getUpdateUser());
	}
	
	public static BillingAlarm createBillingAlarm(BillingAlarmService service, com.clustercontrol.ws.cloud.BillingAlarm wsBillingAlarm) {
		BillingAlarm billingAlarm = new BillingAlarm(service);
		billingAlarm.overwriteByBillingAlarm(wsBillingAlarm);
		return billingAlarm;
	}
}
