/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudType;
import com.clustercontrol.ws.cloud.CloudUser;
import com.clustercontrol.ws.cloud.CloudUserType;
import com.clustercontrol.ws.cloud.Filter;

public class Category extends Element implements ICategory {
	private String id;
	private String name;
	private String description;
	private IdentityManagement im;
	private List<Identity> identities = new ArrayList<Identity>();
	
	@Override
	public Identity[] getIdentities() {
		return identities.toArray(new Identity[0]);
	}
	@Override
	public String getId() {
		return id;
	}
	@Override
	public String getName() {
		return name;
	}
	@Override
	public String getDescription() {
		return description;
	}
	@Override
	public IdentityManagement getIdentityManagement() {
		return im;
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setIdentityManagement(IdentityManagement im) {
		this.im = im;
	}

	public CloudResourceManager getCloudManager() {
		return im.getCloudResourceManager();
	}

	public void addChildIdentity(Identity child) {
		if (!identities.contains(child)) {
			identities.add(child);
			fireElementAdded(ICategory.p2.identities, child);
		}
	}
	
	public void removeChildIdentity(IIdentity child) {
		if (identities.contains(child)) {
			identities.remove(child);
			fireElementRemoved(ICategory.p2.identities, child);
		}
	}
	
	public static Category createCategory(CloudType cloudType, CloudResourceManager root, IdentityManagement im) {
		Category c = new Category();
		
		c.setId(cloudType.getCloudId());
		c.setName(cloudType.getCloudName());
		c.setDescription(cloudType.getDescription());
		c.setIdentityManagement(im);
		
		return c;
	}
	@Override
	public void createChildIdentity(CreateIdentityRequest request) {
		// Web サービス経由で新規追加。
		CloudEndpoint ce = getCloudManager().getEndpoint(CloudEndpoint.class);

		CloudUser cu = new CloudUser();
		cu.setCloudUserName(request.name);
		cu.setCloudUserId(request.id);
		cu.setDescription(request.description);
		cu.setAccessKey(request.key.getAccessKey());
		cu.setSecretKey(request.key.getSecretKey());
		cu.setCloudId(getId());
		cu.setCloudUserType(CloudUserType.PARENT);
		cu.setUserId(request.hinemosUserId);
		
		try {
			// 追加依頼実施。
			CloudUser newCu = ce.addCloudUser(cu);
			Identity child = Identity.createIdentiry(newCu, getCloudManager(), this, null);
			addChildIdentity(child);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	@Override
	public void deleteChildIdentity(String childId) {
		Iterator<Identity> identityIter = identities.iterator();

		while (identityIter.hasNext()) {
			Identity id = identityIter.next();
			if (childId.equals(id.getId())) {
				CloudEndpoint ce = getCloudManager().getEndpoint(CloudEndpoint.class);
				
				try {
					ce.removeCloudUser(id.getId());
					removeChildIdentity(id);
					return;
				}
				catch (Exception e) {
					throw new CloudModelException(e);
				}
			}
		}
	}
	@Override
	public void update() throws InvalidStateException {
		CloudEndpoint ce = getCloudManager().getEndpoint(CloudEndpoint.class);

		Filter f1 = new Filter();
		f1.setName("cloudId");
		f1.getValues().add(getId());
		
		Filter f2 = new Filter();
		f2.setName("parentCloudUserId");
		f2.getValues().add(null);
		
		List<CloudUser> users = null;
		try {
			users = ce.getCloudUsers(Arrays.asList(f1, f2));
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}

		List<Identity> identityList = new ArrayList<Identity>(identities);
		List<Identity> newIdentityList = new ArrayList<Identity>();
		Iterator<CloudUser> userIter = users.iterator();
		while (userIter.hasNext()) {
			CloudUser cu = userIter.next();

			Iterator<Identity> identityIter = identityList.iterator();
			while (identityIter.hasNext()) {
				Identity id = identityIter.next();
				
				if (cu.getCloudUserId().equals(id.getId())) {
					newIdentityList.add(id);
					userIter.remove();
					identityIter.remove();
				}
			}
		}

		for (Identity id: identityList) {
			try {
				removeChildIdentity(id);
			}
			catch (Exception e) {
				throw new CloudModelException(e);
			}
		}

		for (CloudUser cu: users) {
			try {
				Identity child = Identity.createIdentiry(cu, getCloudManager(), this, null);
				addChildIdentity(child);
			}
			catch (Exception e) {
				throw new CloudModelException(e);
			}
		}
		
		for (Identity id: identities) {
			id.update();
		}
		
		super.update();
	}
}
