/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.commons.util.MessageManager;


public class CloudResourceManager extends Element implements ICloudResourceManager {
	private MessageManager bundle_messages = MessageManager.getInstance("messages");
	
	private IEndpointManager endpointManager;
	private IdentityManagement im;
	private HinemosService hs;
	private Inventory iv;
	
	public CloudResourceManager(IEndpointManager endpointManager) {
		this.endpointManager = endpointManager;
	}
	
	@Override
	public IdentityManagement getIdentityManagement() {
		if (im == null) {
			im = new IdentityManagement(this);
		}
		return im;
	}

	@Override
	public IHinemosService getHinemosService() {
		if (hs == null) {
			hs = new HinemosService(this);
		}
		return hs;
	}

	public <T> T getEndpoint(Class<T> clazz) {
		return endpointManager.getEndpoint(clazz);
	}

	@Override
	public String getAccountName() {
		return endpointManager.getAccountName();
	}

	@Override
	public IInventory getInventory() throws CloudModelException {
		if (this.iv == null) {
			Inventory iv = new Inventory(this);
			
			IIdentity credential = iv.getCredential();
			if (credential == null) {
				throw new CloudModelException(bundle_messages.getString("model.warning.not_found_specified_user"), ErrorCodeConstants.IDENTITYMANAGEMENT_INVALID_CLOUDUSER_NOT_FOUND);
			}
			
			this.iv = iv;
		}
		return this.iv;
	}
}