/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

public interface CollectionObserver2<P> extends PropertyObserver2<P> {
	public class ElementAddedEvent<P> extends PropEvent<P, CollectionObserver2<P>> {
		private P addedElement;
		public ElementAddedEvent(Object source, PropertyId2<CollectionObserver2<P>> pid, P addedElement) {
			super(source, pid);
			this.addedElement = addedElement;
		}
		public P getAddedElement() {
			return addedElement;
		}
		@Override
		public void dispatch(CollectionObserver2<P> observer) {
			observer.elementAdded(this);
		}
	}
	
	public class ElementRemovedEvent<P> extends PropEvent<P, CollectionObserver2<P>> {
		private P removedValue;
		public ElementRemovedEvent(Object source, PropertyId2<CollectionObserver2<P>> pid, P addedValue) {
			super(source, pid);
			this.removedValue = addedValue;
		}
		public P getRemovedElement() {
			return removedValue;
		}
		@Override
		public void dispatch(CollectionObserver2<P> observer) {
			observer.elementRemoved(this);
		}
	}
	void elementAdded(ElementAddedEvent<P> event);
	void elementRemoved(ElementRemovedEvent<P> event);
}