/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;



public class EC2Service extends Element implements IEC2Service {
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private Inventory iv;
	private Map<String, Region> regions;

	public EC2Service(Inventory iv) {
		this.iv = iv;
	}
	
	@Override
	public Region[] getRegions() {
		return getRegionsMap().values().toArray(new Region[0]);
	}

	public CloudResourceManager getCloudResourceManager() {
		return iv.getCloudResourceManager();
	}

	public Inventory getInventory() {
		return iv;
	}
	
	@Override
	public Region getRegion(String regionName) {
		Region r = getRegionsMap().get(regionName);
		if (r == null) {
			throw new CloudModelException(bundle_messages.getString("model.warning.not_found_specified_region"), ErrorCodeConstants.EC2SERVICE_INVALID_REGIONID_NOT_FOUND);
		}
		return r; 
	}
	
	private Map<String, Region> getRegionsMap() {
		if (regions == null) {
			Map<String, Region> tempRegions = new HashMap<String, Region>();
			
			// Web サービス経由で新規追加。
			CloudEndpoint ce = getCloudResourceManager().getEndpoint(CloudEndpoint.class);
			try {
				List<com.clustercontrol.ws.cloud.Region> rs = ce.getAllRegion();
				for (com.clustercontrol.ws.cloud.Region r: rs) {
					Region cr = new Region(this);
					cr.setResionName(r.getRegionName());
					tempRegions.put(r.getRegionName(), cr);
				}
			}
			catch (Exception e) {
				throw new CloudModelException(bundle_messages.getString("model.warning.fail_to_get_specified_region"), e);
			}
			regions = tempRegions;
		}
		return regions;
	}
}
