/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;



public interface INetworkSecurityRoot extends IElement {
	interface Matcher {
		boolean match(ISecurityGroup element);
	}
	interface p2 {
		static final PropertyId2<CollectionObserver2<ISecurityGroup>> securityGroups = new PropertyId2<CollectionObserver2<ISecurityGroup>>();
	}
	
	ISecurityGroup getSecurityGroup(String id);
	ISecurityGroup[] getSecurityGroups();

	IRegion getRegion();

	ICloudResourceManager getCloudResourceManager();
	
	ISecurityGroup createSecurityGroup(CreateSecurityGroupRequest request);
	void deleteSecurityGroup(String securityGroupId);

	IIpPermission authorizeIpPermission(AuthorizeIpPermissionRequest request);
	void revokeIpPermission(IIpPermission ipPermission);
}
