/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;
import java.util.List;



public interface IStorage extends IElement {
	// プロパティの Id
	interface p2 {
		static final PropertyId2<ValueObserver2<Date>> updateDate = new PropertyId2<ValueObserver2<Date>>();
		static final PropertyId2<ValueObserver2<String>> facilityId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> facilityName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Integer>> deviceIndex = new PropertyId2<ValueObserver2<Integer>>();
		static final PropertyId2<ValueObserver2<String>> deviceName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> deviceType = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> state = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<List<Tag>>> tags = new PropertyId2<ValueObserver2<List<Tag>>>();
		static final PropertyId2<ValueObserver2<StorageAttachment>> storageAttachment = new PropertyId2<ValueObserver2<StorageAttachment>>();
	}

	// インスタンスの状態
	public enum RegistStateType {
		exist((short)0),
		deleted((short)2);

		private short num;
		
		private RegistStateType(short num) {
			this.num = num;
		}
		
		public short number() {
			return num;
		}
		
		public static RegistStateType byNumber(short num) {
			for (RegistStateType type: RegistStateType.values()) {
				if (type.number() == num) {
					return type;
				}
			}
			return null;
		}
	}
	
	public class Tag {
		private String name;
		private String value;
		
		public Tag() {
		}

		public Tag(String name, String value) {
			this.name = name;
			this.value = value;
		}
		
		public String getName() {
			return name;
		}
		
		public String getValue() {
			return value;
		}
	}

	IStorageRoot getStorageRoot();

	ICloudResourceManager getCloudResourceManager();

	String getStorageId();
	String getStorageName();
	String getStorageType();
	String getSnapshotId();
	String getStorageKind();
	Integer getIops();
	String getCloudId();
	String getState();
	String getCloudUserId();
	String getFacilityId();
	String getFacilityName();
	Integer getDeviceIndex();
	String getDeviceType();
	String getDeviceName();
	IRegion getRegion();
	String getAvailabilityZone();
	Integer getSize();
	RegistStateType getRegistState();
	StorageAttachment getStorageAttachment();
	List<Tag> getTags();
	Date getRegDate();
	Date getUpdateDate();
	String getRegUser();
	String getUpdateUser();
	
	void attachInstance(String instanceId, String deviceName);
	void detachInstance();
}
