/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.log4j.Logger;

import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.InstanceStateChange;
import com.clustercontrol.ws.cloud.StartInstanceRequest;
import com.clustercontrol.ws.cloud.StopInstanceRequest;

public class Instance extends Element implements IInstance {
	private InstanceRoot instanceRoot;
	
	private String facilityId;
	private String facilityName;
	private String instanceId;
	private String instanceName;
	private String platform;
	private String cloudId;
	private String cloudUserId;
	private String availavilityZone;
	private List<GroupIdentifier> securityGroups = new ArrayList<GroupIdentifier>();
	private String publicDnsName;
	private String imageId;
	private String rootDeviceType;
	private StateType state;
	private RegistStateType registState;
	private String type;
	private String keyPair;
	private Date launchTime;
	private List<Tag> tags;
	private String templateId;
	private List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
	private Date regDate;
	private Date updateDate;
	private String regUser;
	private String updateUser;

	public Instance(InstanceRoot instanceRoot) {
		this.instanceRoot = instanceRoot;
	}
	
	@Override
	public InstanceRoot getInstanceRoot() {
		return instanceRoot;
	}
	public void setInstanceRoot(InstanceRoot instanceRoot) {
		this.instanceRoot = instanceRoot;
	}
	@Override
	public String getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(String facilityId) {
		internalSet("facilityId", p2.facilityId, facilityId);
	}
	@Override
	public String getFacilityName() {
		return facilityName;
	}
	public void setFacilityName(String facilityName) {
		internalSet("facilityName", p2.facilityName, facilityName);
	}
	@Override
	public String getInstanceId() {
		return instanceId;
	}
	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}
	@Override
	public String getInstanceName() {
		return instanceName;
	}
	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}
	@Override
	public String getPlatform() {
		return platform;
	}
	public void setPlatform(String platform) {
		this.platform = platform;
	}
	@Override
	public String getCloudId() {
		return cloudId;
	}
	public void setCloudId(String cloudId) {
		this.cloudId = cloudId;
	}
	@Override
	public String getCloudUserId() {
		return cloudUserId;
	}
	public void setCloudUserId(String cloudUserId) {
		this.cloudUserId = cloudUserId;
	}
	@Override
	public Region getRegion() {
		return instanceRoot.getRegion();
	}
	@Override
	public String getAvailabilityZone() {
		return availavilityZone;
	}
	public void setAvailavilityZone(String availavilityZone) {
		this.availavilityZone = availavilityZone;
	}
	@Override
	public List<GroupIdentifier> getSecurityGroups() {
		return securityGroups;
	}
	public void setSecurityGroups(List<GroupIdentifier> securityGroups) {
		this.securityGroups = securityGroups;
	}
	@Override
	public String getPublicDnsName() {
		return publicDnsName;
	}
	public void setPublicDnsName(String publicDnsName) {
		this.publicDnsName = publicDnsName;
	}
	@Override
	public String getImageId() {
		return imageId;
	}
	public void setImageId(String imageId) {
		this.imageId = imageId;
	}
	@Override
	public String getRootDeviceType() {
		return rootDeviceType;
	}
	public void setRootDeviceType(String rootDeviceType) {
		this.rootDeviceType = rootDeviceType;
	}
	@Override
	public StateType getState() {
		return state;
	}
	public void setState(StateType state) {
		internalSet("state", IInstance.p2.state, state);
	}
	@Override
	public RegistStateType getRegistState() {
		return registState;
	}
	public void setRegistState(RegistStateType registState) {
		this.registState = registState;
	}
	@Override
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	@Override
	public String getKeyPair() {
		return keyPair;
	}
	public void setKeyPair(String keyPair) {
		this.keyPair = keyPair;
	}
	@Override
	public Date getLaunchTime() {
		return launchTime;
	}
	public void setLaunchTime(Date launchTime) {
		this.launchTime = launchTime;
	}
	@Override
	public List<Tag> getTags() {
		return tags;
	}
	public void setTags(List<Tag> tags) {
		this.tags = tags;
	}
	@Override
	public String getTemplateId() {
		return templateId;
	}
	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}
	@Override
	public Date getRegDate() {
		return regDate;
	}
	public void setRegDate(Date regDate) {
		this.regDate = regDate;
	}
	@Override
	public Date getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}
	@Override
	public String getRegUser() {
		return regUser;
	}
	public void setRegUser(String regUser) {
		this.regUser = regUser;
	}
	@Override
	public String getUpdateUser() {
		return updateUser;
	}
	public void setUpdateUser(String updateUser) {
		this.updateUser = updateUser;
	}

	@Override
	public void update() throws InvalidStateException {
		CloudInstance cloudInstance = CacheService.getSingleton().get(this, CloudInstance.class);
		if (cloudInstance == null) {
			try {
				cloudInstance = getCloudResourceManager().getEndpoint(CloudEndpoint.class).getInstance(this.getRegion().getRegionName(), this.getInstanceId());
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error("faild to get repositry tree.", e);
			}
		}
		else {
			CacheService.getSingleton().remove(this);
		}

		if (cloudInstance != null) {
			internalUpdate(cloudInstance);
		}
		
		super.update();
	}

	public void internalUpdate(CloudInstance cloudInstance) {
		overwriteByCloudInstance(cloudInstance);
	}

	protected void overwriteByCloudInstance(CloudInstance cloudInstance) {
		this.setFacilityId(cloudInstance.getFacilityId());
		this.setFacilityName(cloudInstance.getFacilityName());
		this.setInstanceId(cloudInstance.getInstanceId());
		this.setInstanceName(cloudInstance.getInstanceName());
		this.setPlatform(cloudInstance.getPlatform() == null ? "LINUX": "WINDOWS");
		this.setCloudId(cloudInstance.getCloudId());
		this.setCloudUserId(cloudInstance.getCloudUserId());
		this.setAvailavilityZone(cloudInstance.getAvailabilityZone());
		List<GroupIdentifier> gis = new ArrayList<GroupIdentifier>();
		for (com.clustercontrol.ws.cloud.GroupIdentifier sg: cloudInstance.getSecurityGroups()) {
			GroupIdentifier gi = new GroupIdentifier();
			gi.setGroupId(sg.getGroupId());
			gi.setGroupName(sg.getGroupName());
			gis.add(gi);
		}
		this.setSecurityGroups(gis);
		this.setPublicDnsName(cloudInstance.getPublicDnsName());
		this.setImageId(cloudInstance.getImageId());
		this.setRootDeviceType(cloudInstance.getRootDeviceType());
		this.setState(cloudInstance.getState() != null ? IInstance.StateType.valueOf(cloudInstance.getState().value()): null);
		this.setRegistState(IInstance.RegistStateType.valueOf(cloudInstance.getRegistState().value()));
		this.setType(cloudInstance.getInstanceType());
		this.setKeyPair(cloudInstance.getKeyPair());
		this.setLaunchTime(cloudInstance.getLaunchTime() != null ? new Date(cloudInstance.getLaunchTime()): null);
		List<Tag> tags = new ArrayList<Tag>();
		for (com.clustercontrol.ws.cloud.Tag t: cloudInstance.getTags()) {
			tags.add(new Tag(t.getName(), t.getValue()));
		}
		this.setTags(tags);
		this.setTemplateId(cloudInstance.getTemplateId());
		List<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
		for (com.clustercontrol.ws.cloud.BlockDeviceMapping d: cloudInstance.getBlockDeviceMappings()) {
			blockDeviceMappings.add(new BlockDeviceMapping(d.getVolumeId(), d.getDeviceName()));
		}
		this.setBlockDeviceMappings(blockDeviceMappings);
		this.setRegDate(cloudInstance.getRegDate() != null ? new Date(cloudInstance.getRegDate()): null);
		this.setUpdateDate(cloudInstance.getUpdateDate() != null ? new Date(cloudInstance.getUpdateDate()): null);
		this.setRegUser(cloudInstance.getRegUser());
		this.setUpdateUser(cloudInstance.getUpdateUser());
		
		this.setTemplateId(cloudInstance.getTemplateId());
	}
	
	public static Instance createInstance(InstanceRoot root, CloudInstance cloudInstance) {
		Instance instance = new Instance(root);
		instance.overwriteByCloudInstance(cloudInstance);
		return instance;
	}

	@Override
	public CloudResourceManager getCloudResourceManager() {
		return instanceRoot.getCloudResourceManager();
	}

	@Override
	public void start() {
//		try {
//			InstanceStateChange change = getCloudResourceManager().getEndpoint(CloudEndpoint.class).startInstance(this.getRegion().getRegionName(), this.getInstanceId());
//			setState(StateType.valueOf(change.getCurrentState().value()));
//		}
//		catch (Exception e) {
//			throw new CloudModelException(e);
//		}
		start(false, null, null);
	}

	@Override
	public void stop() {
//		try {
//			InstanceStateChange change = getCloudResourceManager().getEndpoint(CloudEndpoint.class).stopInstance(this.getRegion().getRegionName(), this.getInstanceId());
//			setState(StateType.valueOf(change.getCurrentState().value()));
//		}
//		catch (Exception e) {
//			throw new CloudModelException(e);
//		}
		stop(false, null, null);
	}

	@Override
	public void attachStorage(String volumeId, String device) {
		try {
			getCloudResourceManager().getEndpoint(CloudEndpoint.class).attachStorage(getRegion().getRegionName(), getInstanceId(), volumeId, device);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public void detachStorage(String volumeId) {
		try {
			getCloudResourceManager().getEndpoint(CloudEndpoint.class).detachStorage(getRegion().getRegionName(), getInstanceId(), volumeId);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	public List<BlockDeviceMapping> getBlockDeviceMappings() {
		return blockDeviceMappings;
	}

	public void setBlockDeviceMappings(List<BlockDeviceMapping> blockDeviceMappings) {
		this.blockDeviceMappings = blockDeviceMappings;
	}

	@Override
	public void registNode(RegistNodeRequest request) {
		try {
			com.clustercontrol.ws.cloud.RegistNodeRequest wsRequest = new com.clustercontrol.ws.cloud.RegistNodeRequest();
	
			com.clustercontrol.ws.cloud.NodeDetail nodeDetail = new com.clustercontrol.ws.cloud.NodeDetail();
			nodeDetail.setDescription(request.getDescription());
			nodeDetail.setFacilityId(request.getFacilityId());
			nodeDetail.setFacilityName(request.getFacilityName());
			nodeDetail.setNodeName(request.getNodeName());
			nodeDetail.setReplaceNode(request.isReplaceNode());
			
			wsRequest.setNodeDetail(nodeDetail);

			wsRequest.setRegion(getRegion().getRegionName());
			wsRequest.setInstanceId(getInstanceId());
			
			CloudInstance instance = getCloudResourceManager().getEndpoint(CloudEndpoint.class).registNode(wsRequest);
			
			internalUpdate(instance);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	// テンプレート用
	@Override
	public void start(Boolean runJobFlg, String jobId, List<TemplateJobsArgument> arguments) {
		StartInstanceRequest request = new StartInstanceRequest();
		request.setInstanceId(instanceId);
		request.setRegion(this.getRegion().getRegionName());
		request.setRunJobFlg(runJobFlg);
		request.setJobId(jobId);
		List<com.clustercontrol.ws.cloud.TemplateJobsArgument> cloudArguments;
		cloudArguments = request.getArguments();
		
		if(arguments != null){
			for(TemplateJobsArgument argument: arguments){
				com.clustercontrol.ws.cloud.TemplateJobsArgument cloudArgument = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
				cloudArgument.setJobId(argument.getJobId());
				cloudArgument.setArg(argument.getArg());
				cloudArguments.add(cloudArgument);
			}
		}

		try {
			InstanceStateChange change = getCloudResourceManager().getEndpoint(CloudEndpoint.class).startInstance(request);
			setState(StateType.valueOf(change.getCurrentState().value()));
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
	
	// テンプレート用
	@Override
	public void stop(Boolean runJobFlg, String jobId, List<TemplateJobsArgument> arguments) {
		StopInstanceRequest request = new StopInstanceRequest();
		request.setInstanceId(instanceId);
		request.setRegion(this.getRegion().getRegionName());
		request.setRunJobFlg(runJobFlg);
		request.setJobId(jobId);
		List<com.clustercontrol.ws.cloud.TemplateJobsArgument> cloudArguments;
		cloudArguments = request.getArguments();
		
		if(arguments != null){
			for(TemplateJobsArgument argument: arguments){
				com.clustercontrol.ws.cloud.TemplateJobsArgument cloudArgument = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
				cloudArgument.setJobId(argument.getJobId());
				cloudArgument.setArg(argument.getArg());
				cloudArguments.add(cloudArgument);
			}
		}

		try {
			InstanceStateChange change = getCloudResourceManager().getEndpoint(CloudEndpoint.class).stopInstance(request);
			setState(StateType.valueOf(change.getCurrentState().value()));
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}
	}
}
