/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;

import com.clustercontrol.ws.cloud.CloudInstanceBackup;

public class InstanceBackup extends Element implements IInstanceBackup {
	private InstanceBackupRoot instanceBackupRoot;
	private CloudInstanceBackup cloudInstanceBackup;

	private ExistStatusType existStatus;
	
	private InstanceBackup(InstanceBackupRoot instanceBackupRoot){
		this.instanceBackupRoot = instanceBackupRoot;
	}

	public CloudInstanceBackup getInstanceBackup() {
		return cloudInstanceBackup;
	}

	@Override
	public String getImageId() {
		return cloudInstanceBackup.getImageId();
	}

	@Override
	public String getImageName() {
		return cloudInstanceBackup.getImageName();
	}

	@Override
	public String getCloudId() {
		return cloudInstanceBackup.getCloudId();
	}

	@Override
	public String getDescription() {
		return cloudInstanceBackup.getDescription();
	}

	@Override
	public String getImageType() {
		return cloudInstanceBackup.getImageType();
	}

	@Override
	public String getFacilityId() {
		return cloudInstanceBackup.getFacilityId();
	}

	@Override
	public String getFacilityName() {
		return cloudInstanceBackup.getFacilityName();
	}

	@Override
	public String getInstanceId() {
		return cloudInstanceBackup.getInstanceId();
	}

	@Override
	public String getInstanceName() {
		return cloudInstanceBackup.getInstanceName();
	}

	@Override
	public String getRegion() {
		return cloudInstanceBackup.getRegion();
	}

	@Override
	public String getAvailabilityZone() {
		return cloudInstanceBackup.getAvailabilityZone();
	}

	@Override
	public String getPlatform() {
		return cloudInstanceBackup.getPlatform();
	}

	@Override
	public String getNodeName() {
		return cloudInstanceBackup.getNodeName();
	}

	@Override
	public String getKeyName() {
		return cloudInstanceBackup.getKeyName();
	}

	@Override
	public ExistStatusType getExistsStatus() {
		return existStatus;
	}

	@Override
	public Date getRegDate() {
		return new Date(cloudInstanceBackup.getRegDate());
	}
	
	@Override
	public String getRegUser() {
		return cloudInstanceBackup.getRegUser();
	}
	
	public void setExistsStatus(ExistStatusType existStatus) {
		internalSet("existStatus", p2.existStatus, existStatus);
	}

	public InstanceBackupRoot getInstanceBackupRoot() {
		return instanceBackupRoot;
	}

	public static InstanceBackup createInstanceBackup(InstanceBackupRoot root, CloudInstanceBackup cloudInstanceBackup) {
		InstanceBackup instanceBackup = new InstanceBackup(root);
		instanceBackup.overwriteByCloudInstanceBackup(cloudInstanceBackup);
		return instanceBackup;
	}

	public void internalUpdate(CloudInstanceBackup cloudInstanceBackup) {
		overwriteByCloudInstanceBackup(cloudInstanceBackup);
	}
	
	public void overwriteByCloudInstanceBackup(CloudInstanceBackup cloudInstanceBackup) {
		this.cloudInstanceBackup = cloudInstanceBackup;
		setExistsStatus(cloudInstanceBackup.getRestoreStatus() != null ? ExistStatusType.byNumber(cloudInstanceBackup.getRestoreStatus()): null);
	}
}
