/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class Inventory extends Element implements IInventory {
	private CollectionObserver2<IIdentity> identityObserver = new CollectionObserver2<IIdentity>() {
		@Override
		public void elementAdded(ElementAddedEvent<IIdentity> event) {
			IIdentity element = event.getAddedElement();
			if (element.getHinemosUserId().equals(cm.getAccountName())) {
				credential = element;
			}
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<IIdentity> event) {
			IIdentity element = event.getRemovedElement();
			if (element.getHinemosUserId().equals(cm.getAccountName())) {
				credential = element;
			}
		}
	};
	
	private CloudResourceManager cm;
	private Map<Class<? extends IFolder>, IFolder> folders = new HashMap<Class<? extends IFolder>, IFolder>();
	private IIdentity credential;

	public Inventory(CloudResourceManager cm) {
		this.cm = cm;
		
		// 現在ログオンしているユーザーが、AWS のセキュリティ情報を持っているか確認。
		String currentId = cm.getAccountName();
		loopEnd:
		for (Category c: this.cm.getIdentityManagement().getCategories()) {
			c.addPropertyObserver2(ICategory.p2.identities, identityObserver);
			
			for (Identity parent: c.getIdentities()) {
				parent.addPropertyObserver2(IIdentity.p2.identities, identityObserver);
				
				if (credential == null && parent.getHinemosUserId().equals(currentId)) {
					credential = parent;
					break loopEnd;
				}
				
				for (Identity child: parent.getIdentities()) {
					if (credential == null && child.getHinemosUserId().equals(currentId)) {
						credential = child;
						break loopEnd;
					}
				}
			}
		}
		
		EC2Service ec2Service = new EC2Service(this);
		folders.put(IEC2Service.class, ec2Service);

		BillingAlarmService billingAlarmService = new BillingAlarmService(this);
		folders.put(IBillingAlarmService.class, billingAlarmService);

		TemplateManagement templateManagement = new TemplateManagement(this);
		folders.put(ITemplateManagement.class, templateManagement);
	}
	@Override
	public List<IFolder> getFolders() {
		return new ArrayList<IFolder>(folders.values());
	}
	@Override
	public boolean isAccessible() {
		return credential != null;
	}

	public CloudResourceManager getCloudResourceManager() {
		return cm;
	}
	
	public IIdentity getCredential() {
		return credential;
	}
	@SuppressWarnings("unchecked")
	@Override
	public <P extends IFolder> P getFolder(Class<P> clazz) {
		return (P)folders.get(clazz);
	}
}