/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

public class Region extends Element implements IRegion {
	private String regionName;
	private EC2Service ec2Service;
//	private NetworkSecurityRoot nsr;
	private InstanceRoot ir;
	private StorageRoot sr;
	private BackupManagement bm;
	
	public Region(EC2Service ec2Service) {
		this.ec2Service = ec2Service;
	}

	@Override
	public EC2Service getEC2Service() {
		return ec2Service;
	}
	
	@Override
	public String getRegionName() {
		return regionName;
	}

	public void setResionName(String regionName) {
		this.regionName = regionName;
	}
	
	@Override
	public CloudResourceManager getCloudResourceManager() {
		return ec2Service.getCloudResourceManager();
	}

//	@Override
//	public NetworkSecurityRoot getNetworkSecurityRoot() {
//		if (nsr == null) {
//			nsr = new NetworkSecurityRoot(this);
//		}
//		return nsr;
//	}

	@Override
	public InstanceRoot getInstanceRoot() {
		if (ir == null) {
			ir = new InstanceRoot(this);
		}
		return ir;
	}

	@Override
	public StorageRoot getStorageRoot() {
		if (sr == null) {
			sr = new StorageRoot(this);
		}
		return sr;
	}
	
	@Override
	public BackupManagement getBackupManagement() {
		if (bm == null) {
			bm = new BackupManagement(this);
		}
		return bm;
	}
}
