/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;

public class StorageAttachment {
	private String instanceId;
	private String device;
	private String state;
	private Date AttachTime;
	private boolean deleteOnTerminate;

	public StorageAttachment(String instanceId, String device, String state, boolean deleteOnTerminate, Date AttachTime) {
		this.instanceId = instanceId;
		this.device = device;
		this.state = state;
		this.deleteOnTerminate = deleteOnTerminate;
		this.AttachTime = AttachTime;
	}
	
	public String getInstanceId() {
		return instanceId;
	}

	public String getDevice() {
		return device;
	}

	public String getState() {
		return state;
	}

	public Date getAttachTime() {
		return AttachTime;
	}

	public boolean isDeleteOnTerminate() {
		return deleteOnTerminate;
	}

	public boolean equals(Object anObject) {
		if (this == anObject) {
			return true;
		}
		if (anObject instanceof StorageAttachment) {
			StorageAttachment value = (StorageAttachment)anObject;
			return 
				equalValue(instanceId, value.instanceId) &&
				equalValue(device, value.device) &&
				equalValue(state, value.state) &&
				equalValue(deleteOnTerminate, value.deleteOnTerminate) &&
				equalValue(AttachTime, value.AttachTime);
		}
		return false;
	}
	
	public int hashCode() {
		int h = 17;
		h = 37*h + ((this.instanceId != null) ? this.instanceId.hashCode() : 0);
		h = 37*h + ((this.device != null) ? this.device.hashCode() : 0);
		h = 37*h + ((this.state != null) ? this.state.hashCode() : 0);
		h = 37*h + (this.deleteOnTerminate ? 1: 0);
		h = 37*h + ((this.AttachTime != null) ? this.AttachTime.hashCode() : 0);
		return h;
	}
	
	public String toString() {
	      StringBuffer str = new StringBuffer("{");
	      str.append("instanceId=" + getInstanceId() + " " + "device=" + getDevice() + " " + "state=" + getState() + " " + "deleteOnTerminate=" + isDeleteOnTerminate() + " " + "AttachTime=" + getAttachTime());
	      str.append('}');
	      return(str.toString());
	}
	
	private static boolean equalValue(Object o1, Object o2) {
		return o1 == null ? o2 == null: o1.equals(o2);
	}
}
