/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.aws.presenter;

import java.util.Date;

import com.clustercontrol.ws.cloud.CloudTemplate;

public class Template extends Element implements ITemplate {
	
	
	ITemplateManagement root;
	CloudTemplate template;
	
	public Template(ITemplateManagement root, CloudTemplate template){
		this.root = root;
		this.template = template;
	}

	public CloudTemplate getTemplate() {
		return template;
	}

	@Override
	public ITemplateManagement getTemplateManagement() {
		return root;
	}

	@Override
	public String getImageId() {
		return template.getImageId();
	}

	@Override
	public String getCloudId() {
		return template.getCloudId();
	}

	@Override
	public String getRegion() {
		return template.getRegion();
	}

	@Override
	public Date getRegDate() {
		return new Date(template.getRegDate());
	}
	
	@Override
	public String getRegUser() {
		return template.getRegUser();
	}

	@Override
	public String getTemplateId() {
		return template.getTemplateId();
	}

	@Override
	public String getTemplateName() {
		return template.getTemplateName();
	}

	@Override
	public String getCloudUserId() {
		return template.getCloudUserId();
	}

	@Override
	public String getJobUnitId() {
		return template.getJobUnitId();
	}

	@Override
	public String getLaunchJobId() {
		return template.getLaunchJobId();
	}

	@Override
	public String getStartJobId() {
		return template.getStartJobId();
	}

	@Override
	public String getStopJobId() {
		return template.getStopJobId();
	}

	@Override
	public Date getUpdateDate() {
		return new Date(template.getUpdateDate());
	}

	@Override
	public String getUpdateUser() {
		return template.getUpdateUser();
	}
	

	public void setTemplate(CloudTemplate template) {
		internalSet("template", p2.cloudTemplate, template);
	}

	public void setCloudId(String cloudId) {
		template.setCloudId(cloudId);
	}

	public void setTEmplateId(String templateId){
		template.setTemplateId(templateId);
	}
	
	public void setTEmplateName(String templateName){
		template.setTemplateName(templateName);
	}

	public void setRegion(String region) {
		template.setRegion(region);
	}

	public void setImageId(String imageId) {
		template.setImageId(imageId);
	}
	
	public void setLauchJobId(String lauchJobId) {
		template.setLaunchJobId(lauchJobId);
	}
	
	public void setStartJobId(String startJobId) {
		template.setStartJobId(startJobId);
	}
	
	public void setStopJobId(String stopJobId) {
		template.setStopJobId(stopJobId);
	}
	
	public void internalUpdate(CloudTemplate cloudTemplate){
		setTemplate(cloudTemplate);
		super.update();
	}
}
