/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

//import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
//import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.RequiredFieldColorConstant;

public class ControlUtil {
	private ControlUtil(){};

	@SuppressWarnings("unchecked")
	public static <T> T deepCopy(T value) {
		T model = null;
		try {
			ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
			ObjectOutputStream out = new ObjectOutputStream(byteOut);
			out.writeObject(value);
			ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
			ObjectInputStream in = new ObjectInputStream(byteIn);
			model = (T)in.readObject();
		}
		catch (Exception e) {
			throw new IllegalStateException(e);
		}
		return model;
	}
	
	public static void setRequired(Control[] requiredControls){
		for(Control requiredControl: requiredControls){
			if(requiredControl instanceof Text){
				if(((Text)requiredControl).getText().equals("")){
					requiredControl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				}
				((Text)requiredControl).addModifyListener(new ModifyListener(){
					@Override
					public void modifyText(ModifyEvent e) {
						if(((Text)e.getSource()).getText().equals("")){
							((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
						} else {
							((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
						}
					}
				});
			}
//			if(requiredControl instanceof Combo){
//				if(((Combo)requiredControl).getText().equals("")){
//					requiredControl.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
//				}
//				((Combo)requiredControl).addModifyListener(new ModifyListener(){
//					@Override
//					public void modifyText(ModifyEvent e) {
//						if(((Combo)e.getSource()).getText().equals("") || ((Combo)e.getSource()).indexOf(((Combo)e.getSource()).getText()) == -1){
//							((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
//						} else {
//							((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
//						}
//					}
//				});
//				((Combo)requiredControl).addKeyListener(new KeyAdapter(){
//					@Override
//					public void keyPressed(KeyEvent e) {
//						if(!Character.isISOControl(e.character) || e.character == SWT.BS || e.character == SWT.DEL){
//							e.doit = false;
//						}
//					}
//				});
//			}
		}
	}

	public static void setInputRestriction(Text[] texts,final Pattern pattern){
		for(Text text: texts){
			text.addVerifyListener(new VerifyListener(){
				Matcher matcher;
				@Override
				public void verifyText(VerifyEvent e) {
					if(!e.text.isEmpty()){
						String srcText = ((Text)e.getSource()).getText();
						matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
						if(!matcher.matches()){
							e.doit = false;
						}
					}
				}
			});
		}
	}

	public static void setInputRestriction(Control[] controls,final Pattern pattern){
		for(Control control: controls){
			if(control instanceof Text){
				((Text)control).addVerifyListener(new VerifyListener(){
					Matcher matcher;
					@Override
					public void verifyText(VerifyEvent e) {
						if(!e.text.isEmpty()){
							String srcText = ((Text)e.getSource()).getText();
							matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
							if(!matcher.matches()){
								e.doit = false;
							}
						}
					}
				});
			} else if(control instanceof Combo){
				((Combo)control).addVerifyListener(new VerifyListener(){
					Matcher matcher;
					@Override
					public void verifyText(VerifyEvent e) {
						if(!e.text.isEmpty()){
							String srcText = ((Combo)e.getSource()).getText();
							matcher = pattern.matcher(srcText.substring(0, e.start) + e.text + srcText.substring(e.end));
							if(!matcher.matches()){
								e.doit = false;
							}
						}
					}
				});
			}
		}
	}
	
	public static void setDigitOnlyInput(Text[] texts){
		for(Text text: texts){
			text.addModifyListener(new ModifyListener(){
				Pattern pattern = Pattern.compile("^-?[0-9]+$");
				Matcher matcher;
				@Override
				public void modifyText(ModifyEvent e) {
					matcher = pattern.matcher(((Text)e.getSource()).getText()); 
					if(matcher.find()){
						((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
					} else {
						((Text)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
					}
				}
			});
			text.addKeyListener(new KeyAdapter(){
				@Override
				public void keyPressed(KeyEvent e) {
					if(!Character.isDigit(e.character) && !Character.isISOControl(e.character) && e.character != '-'){
						e.doit = false;
					}
				}
			});
		}
	}
}
