/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.cloud.ui.views.BillingAlarmsView;
import com.clustercontrol.cloud.ui.views.InstanceBackupView;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.cloud.ui.views.ScopeView;
import com.clustercontrol.cloud.ui.views.StorageBackupView;
import com.clustercontrol.cloud.ui.views.StoragesView2;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.UserDetailView;
import com.clustercontrol.cloud.ui.views.UsersView;

public class Perspective extends ClusterControlPerspectiveBase{
	public static final String Id = "com.clustercontrol.cloud.ui.Perspective";
	
	@Override
	public void createInitialLayout(IPageLayout layout) {
		super.createInitialLayout(layout);

		String editorArea = layout.getEditorArea();
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, 0.25f, editorArea);
		IFolderLayout rightTop = layout.createFolder("rightTop", IPageLayout.TOP, 0.5f, editorArea);
		IFolderLayout rightBottom = layout.createFolder("rightBottom", IPageLayout.BOTTOM, 0.5f, editorArea);

		left.addView(ScopeView.Id);
		left.addView(UsersView.Id);
		
		rightTop.addView(InstancesView2.Id);
		rightTop.addView(StoragesView2.Id);
		rightTop.addView(TemplatesView.Id);
//		rightTop.addView(SecurityGroupsView.Id);
		rightTop.addView(BillingAlarmsView.Id);

		rightBottom.addView(InstanceBackupView.Id);
		rightBottom.addView(StorageBackupView.Id);
//		rightBottom.addView(SecurityGroupDetailView.Id);
		rightBottom.addView(UserDetailView.Id);
	}
}