/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.presenter.BlockDeviceMapping;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class AttachInstanceDialog extends Dialog {
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");
//	private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");

	private IInstance instance;
	private Table table;
	private TableViewer tableViewer;
	private Text availabilityZone;
	private Text instanceName;

	private String storageId;
	private String deviceName;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AttachInstanceDialog(Shell parentShell, IInstance instance) {
		super(parentShell);
		this.instance = instance;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblAvailabilityZone = new Label(container, SWT.NONE);
		lblAvailabilityZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityZone.setText(bundle_dialog_label.getString("dialog.attach_instance.availability_zone_title"));
		
		availabilityZone = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		availabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		availabilityZone.setText(instance.getAvailabilityZone());
		
		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(bundle_dialog_label.getString("dialog.attach_instance.instance_title"));
		
		instanceName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		instanceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		instanceName.setText(instance.getInstanceId());
		
		Label lblDevice = new Label(container, SWT.NONE);
		lblDevice.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDevice.setText(bundle_dialog_label.getString("dialog.attach_instance.device_title"));
		
		instance.update();
		Combo device = new Combo(container, SWT.READ_ONLY);
		device.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		for(AvailableDevice ad: AvailableDevice.values()){
			Boolean flg = true;
			for(BlockDeviceMapping vol: instance.getBlockDeviceMappings()){
				if(vol.getDeviceName().equals(ad.toString())){
					flg = false;
					break;
				}
			}
			if(flg){
				device.add(ad.toString());
			}
		}
		if (device.getItemCount() > 0) {
			device.select(0);
			deviceName = device.getText();
		}

		device.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				AttachInstanceDialog.this.deviceName = ((Combo)e.getSource()).getText();
			}
		});		
		
		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		TableColumn tblclmnVolumeId = new TableColumn(table, SWT.NONE);
		tblclmnVolumeId.setWidth(90);
		tblclmnVolumeId.setText(bundle_dialog_label.getString("dialog.attach_instance.column.volume_id"));

		TableColumn tableColumn_6 = new TableColumn(table, SWT.NONE);
		tableColumn_6.setWidth(70);
		tableColumn_6.setText(bundle_dialog_label.getString("dialog.attach_instance.column.volume_name"));
		
		TableColumn tableColumn = new TableColumn(table, SWT.NONE);
		tableColumn.setWidth(70);
		tableColumn.setText(bundle_dialog_label.getString("dialog.attach_instance.column.type"));
		
		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(70);
		tableColumn_1.setText(bundle_dialog_label.getString("dialog.attach_instance.column.device"));
		
		TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);
		tableColumn_2.setWidth(70);
		tableColumn_2.setText(bundle_dialog_label.getString("dialog.attach_instance.column.snapshot_id"));
		
		TableColumn tableColumn_3 = new TableColumn(table, SWT.NONE);
		tableColumn_3.setWidth(70);
		tableColumn_3.setText(bundle_dialog_label.getString("dialog.attach_instance.column.size"));
		
		TableColumn tableColumn_4 = new TableColumn(table, SWT.NONE);
		tableColumn_4.setWidth(70);
		tableColumn_4.setText(bundle_dialog_label.getString("dialog.attach_instance.column.volume_type"));
		
		TableColumn tableColumn_5 = new TableColumn(table, SWT.NONE);
		tableColumn_5.setWidth(70);
		tableColumn_5.setText(bundle_dialog_label.getString("dialog.attach_instance.column.iops"));
		
		instance.getRegion().getStorageRoot().update();
		List<IStorage> availableVolumes = new ArrayList<IStorage>(Arrays.asList(instance.getRegion().getStorageRoot().getStorages()));
		Iterator<IStorage> itav = availableVolumes.iterator();
		while (itav.hasNext()){
			IStorage storage = itav.next();
			if (storage.getStorageAttachment() != null || !(instance.getAvailabilityZone().equals(storage.getAvailabilityZone())) || storage.getRegistState() == IStorage.RegistStateType.deleted){
				itav.remove();
			}
		}
		
		tableViewer = new TableViewer(table);
		VolumeProvider vp = new VolumeProvider();
		tableViewer.setContentProvider(vp.getVolumeContentProvider());
		tableViewer.setInput(availableVolumes);
		tableViewer.setLabelProvider(vp.getVolumeLabelProvider());
		table.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				storageId = ((IStorage)e.item.getData()).getStorageId();
			}
		});
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {

		if(this.storageId == null || this.deviceName == null || "".equals(this.deviceName)){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}		

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("attach_storage"));
	}

	public String getStorageId(){
		return storageId;
	}

	public String getDeviceName() {
		return deviceName;
	}
}
