/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IInstance.RegistStateType;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class AttachStorageDialog extends Dialog {
	public static class VolumeProvider {
		private VolumeContentProvider vcp;
		private VolumeLabelProvider vlp;
		
		public VolumeProvider(){
			this.vcp = new VolumeContentProvider();
			this.vlp = new VolumeLabelProvider();
		}
		
		public class VolumeContentProvider implements IStructuredContentProvider {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((java.util.List<?>)inputElement).toArray();
			}
			@Override
			public void dispose() {
			}
			@Override
			public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
			}
		}
		
		public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				IStorage storage = (IStorage)element;
				Boolean b1 = false;
				Boolean b2 = false;
				if(storage.getStorageAttachment() != null){
					b1 = true;
					Pattern p = Pattern.compile(AvailableDevice.ROOT_DEVICE+".*");
					Matcher m = p.matcher(storage.getStorageAttachment().getDevice());
					if(m.find()){
						b2 = true;
					}
				}
				switch(columnIndex) {
					case 0:
						return storage.getStorageId();
					case 1:
						return b1? (storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice(): "") : "";
					case 2:
						return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
					case 3:
						return storage.getSize() != null ? String.valueOf(storage.getSize()): "";
					case 4:
						return b2? "Root" : "EBS";
					case 5:
						return storage.getIops() != null? String.valueOf(storage.getIops()) : "";
					case 6:
						return storage.getStorageAttachment() != null ? Boolean.toString(storage.getStorageAttachment().isDeleteOnTerminate()): "";
					}
				return null;
			}
			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		}

		public VolumeContentProvider getVolumeContentProvider(){
			return this.vcp;
		}

		public VolumeLabelProvider getVolumeLabelProvider(){
			return this.vlp;
		}
	}
	
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");
	private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");

	private Text availabilityZone;
	private Combo comboInstance;
	private Table tblVolume;
	private TableViewer tableViewer;
	private Combo device;

	private IStorage storage;
	private String instanceId;
	private String deviceName;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AttachStorageDialog(Shell parentShell, IStorage storage) {
		super(parentShell);
		this.storage = storage;
	}

	public String getInstanceId(){
		return instanceId;
	}

	public String getDeviceName(){
		return deviceName;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		storage.update();
		
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(5, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		Label lblAvailabilityZone = new Label(container, SWT.NONE);
		lblAvailabilityZone.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblAvailabilityZone.setText(bundle_dialog_label.getString("dialog.attach_storage.availability_zone_title"));
		
		availabilityZone = new Text(container, SWT.READ_ONLY);
		availabilityZone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		availabilityZone.setText(storage.getAvailabilityZone());
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(bundle_dialog_label.getString("dialog.attach_storage.instance_title"));
		
		comboInstance = new Combo(container, SWT.READ_ONLY);
		comboInstance.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				IInstance instance = (IInstance)comboInstance.getData(comboInstance.getText());
				instanceId = instance.getInstanceId();

				List<IStorage> storages = new ArrayList<IStorage>();
				for (IStorage s: storage.getStorageRoot().getStorages()) {
					if (instanceId.equals(s.getStorageAttachment() == null ? null: s.getStorageAttachment().getInstanceId())) {
						storages.add(s);
					}
				}
				AttachStorageDialog.this.updateSelection(storages);
			}
		});
		GridData gd_instance = new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1);
		gd_instance.widthHint = 199;
		comboInstance.setLayoutData(gd_instance);

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblVolumeType = new Label(container, SWT.NONE);
		lblVolumeType.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVolumeType.setText(bundle_dialog_label.getString("dialog.attach_storage.volume_type_title"));
		
		Combo volumeType = new Combo(container, SWT.NONE);
		volumeType.setEnabled(false);
		GridData gd_volumeType = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_volumeType.widthHint = 226;
		volumeType.setLayoutData(gd_volumeType);
		
		volumeType.setText(bundle_volume_type.getString(storage.getStorageKind().toString()));
		
		Label lblVolumeSize = new Label(container, SWT.NONE);
		GridData gd_lblVolumeSize = new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1);
		gd_lblVolumeSize.widthHint = 83;
		lblVolumeSize.setLayoutData(gd_lblVolumeSize);
		lblVolumeSize.setText(bundle_dialog_label.getString("dialog.attach_storage.volume_size_title"));
		
		Spinner volumeSize = new Spinner(container, SWT.BORDER);
		volumeSize.setEnabled(false);
		GridData gd_volumeSize = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_volumeSize.widthHint = 134;
		volumeSize.setLayoutData(gd_volumeSize);
		
		volumeSize.setSelection(storage.getSize());
		
		Label lblGib = new Label(container, SWT.NONE);
		GridData gd_lblGib = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_lblGib.widthHint = 55;
		lblGib.setLayoutData(gd_lblGib);
		lblGib.setText("GiB");
		
		Label lblIops = new Label(container, SWT.NONE);
		lblIops.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblIops.setText(bundle_dialog_label.getString("dialog.attach_storage.iops_title"));
		
		Combo iops = new Combo(container, SWT.NONE);
		iops.setEnabled(false);
		GridData gd_iops = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_iops.widthHint = 122;
		iops.setLayoutData(gd_iops);
		
		if(storage.getIops() != null) iops.setText(String.valueOf(storage.getIops()));
		
		Label lblDeleteOnTermination = new Label(container, SWT.NONE);
		lblDeleteOnTermination.setText(bundle_dialog_label.getString("dialog.attach_storage.delete_on_termination_title"));
		
		Button btnDeleteOnTermination = new Button(container, SWT.CHECK);
		btnDeleteOnTermination.setEnabled(false);
		btnDeleteOnTermination.setAlignment(SWT.CENTER);
		new Label(container, SWT.NONE);
		
		if(storage.getStorageAttachment() != null && storage.getStorageAttachment().isDeleteOnTerminate()){
			btnDeleteOnTermination.setSelection(true);
		}
			
		Label lblSnapshot = new Label(container, SWT.NONE);
		lblSnapshot.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSnapshot.setText(bundle_dialog_label.getString("dialog.attach_storage.snapshot_title"));
		
		Combo snapshot = new Combo(container, SWT.NONE);
		snapshot.setEnabled(false);
		snapshot.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		new Label(container, SWT.NONE);
		
		snapshot.setText(storage.getSnapshotId());
		
		Label lblDevice = new Label(container, SWT.NONE);
		lblDevice.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDevice.setText(bundle_dialog_label.getString("dialog.attach_storage.device_title"));
		
		device = new Combo(container, SWT.READ_ONLY);
		GridData gd_device = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_device.widthHint = 242;
		device.setLayoutData(gd_device);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		tblVolume = new Table(container, SWT.BORDER | SWT.FULL_SELECTION | SWT.VIRTUAL);
		tblVolume.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {

			}
		});
		tblVolume.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				tblVolume.select(-1);
			}
		});
		tblVolume.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));
		tblVolume.setHeaderVisible(true);
		tblVolume.setLinesVisible(true);
		
		TableColumn tblclmnType = new TableColumn(tblVolume, SWT.NONE);
		tblclmnType.setWidth(100);
		tblclmnType.setText(bundle_dialog_label.getString("dialog.attach_storage.column.storage_id"));
		
		TableColumn tblclmnDevice = new TableColumn(tblVolume, SWT.NONE);
		tblclmnDevice.setWidth(100);
		tblclmnDevice.setText(bundle_dialog_label.getString("dialog.attach_storage.column.device"));
		
		TableColumn tblclmnSnapshotId = new TableColumn(tblVolume, SWT.NONE);
		tblclmnSnapshotId.setWidth(100);
		tblclmnSnapshotId.setText(bundle_dialog_label.getString("dialog.attach_storage.column.snapshot_id"));
		
		TableColumn tblclmnSize = new TableColumn(tblVolume, SWT.NONE);
		tblclmnSize.setWidth(100);
		tblclmnSize.setText(bundle_dialog_label.getString("dialog.attach_storage.column.size"));
		
		TableColumn tblclmnVolumeType = new TableColumn(tblVolume, SWT.NONE);
		tblclmnVolumeType.setWidth(100);
		tblclmnVolumeType.setText(bundle_dialog_label.getString("dialog.attach_storage.column.volume_type"));
		
		TableColumn tblclmnIops = new TableColumn(tblVolume, SWT.NONE);
		tblclmnIops.setWidth(100);
		tblclmnIops.setText(bundle_dialog_label.getString("dialog.attach_storage.column.iops"));
		
		TableColumn tblclmnDeleteOnTermination = new TableColumn(tblVolume, SWT.NONE);
		tblclmnDeleteOnTermination.setWidth(142);
		tblclmnDeleteOnTermination.setText(bundle_dialog_label.getString("dialog.attach_storage.column.delete_on_termination"));

		tableViewer = new TableViewer(tblVolume);
		VolumeProvider vp = new VolumeProvider();
		tableViewer.setContentProvider(vp.getVolumeContentProvider());
		tableViewer.setLabelProvider(vp.getVolumeLabelProvider());

		storage.getRegion().getInstanceRoot().update();
		for(IInstance instance: storage.getRegion().getInstanceRoot().getInstances()){
			if (instance.getAvailabilityZone().equals(storage.getAvailabilityZone()) && instance.getRegistState() != RegistStateType.deleted) {
				comboInstance.setData(instance.getInstanceId(), instance);
				comboInstance.add(instance.getInstanceId());
			}
		}
		if (comboInstance.getItemCount() > 0) {
			comboInstance.select(0);
		}

		return area;
	}

	@SuppressWarnings("unchecked")
	protected void updateSelection(Object o){
		tableViewer.setInput(o);
		
		device.removeAll();
		for(AvailableDevice ad: AvailableDevice.values()){
			Boolean b = true;
			for(IStorage storage: (List<IStorage>)o){
				if(ad.toString().equals(storage.getStorageAttachment()!= null ? storage.getStorageAttachment().getDevice(): null)){
					b = false;
					break;
				}
			}
			if(b){
				device.add(ad.toString());
			}
		}
		if (device.getItemCount() > 0) {
			device.select(0);
		}
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(800, 600);
	}

	@Override
	protected void okPressed() {
		if(instanceId == null || "".equals(device.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}
		
		deviceName = device.getText();
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("attach_storage"));
	}
}
