/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

public enum AvailableIops {
	X100(100),
	X200(200),
	X300(300),
	X400(400),
	X500(500),
	X600(600),
	X700(700),
	X800(800),
	X900(900),
	X1000(1000),
	;
    
    private int value;

    private AvailableIops(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }
 
    @Override
	public String toString(){
    	return String.valueOf(this.value);
    }

    public static AvailableIops fromValue(int value) {
        if ("".equals(value)) {
            throw new IllegalArgumentException("Value cannot be empty!");	        
        } else if (value == 100) {
            return AvailableIops.X100;	        
        } else if (value == 200) {
            return AvailableIops.X200;	        
        } else if (value == 300) {
            return AvailableIops.X300;	        
        } else if (value == 400) {
            return AvailableIops.X400;	        
        } else if (value == 500) {
            return AvailableIops.X500;	        
        } else if (value == 600) {
            return AvailableIops.X600;	        
        } else if (value == 700) {
            return AvailableIops.X700;	        
        } else if (value == 800) {
            return AvailableIops.X800;	        
        } else if (value == 900) {
            return AvailableIops.X900;	        
        } else if (value == 1000) {
            return AvailableIops.X1000;
        } else {
            throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
        }
    }
}

