/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.cloud.aws.presenter.CreateBillingAlarmRequest;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarm;
import com.clustercontrol.cloud.aws.presenter.ModifyBillingAlarmRequest;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyRelationInfo;

public class ChargeAlertDialog extends Dialog {
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");
	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
	
	private Text txtAlarmId;
	private Text txtAlarmName;
	private Text txtThresholdInfoLimit;
	private Text txtThresholdWarnLimit;
	private Text txtDescription;
	private Button btnValidFlg;

	private ModifyBillingAlarmRequest modifyRequest;
	private CreateBillingAlarmRequest createRequest;

	private IBillingAlarm input = null;
	
	private List<NotifyRelationInfo> notifyRelationInfoList;
	
	/** 通知情報 */
	private NotifyIdListComposite notifyInfo = null;
	
	private CloudResourceProvider provider;
	private Combo cmbTarget;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 * @wbp.parser.constructor
	 */
	public ChargeAlertDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(new GridLayout(3, false));
		
		Label lblAlarmId = new Label(container, SWT.NONE);
		lblAlarmId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAlarmId.setAlignment(SWT.RIGHT);
		lblAlarmId.setText(bundle_dialog_label.getString("dialog.charge_alert.alarm_id_title"));
		new Label(container, SWT.NONE);
		
		txtAlarmId = new Text(container, SWT.BORDER);
		txtAlarmId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		
		Label lblAlarmName = new Label(container, SWT.NONE);
		lblAlarmName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAlarmName.setAlignment(SWT.RIGHT);
		lblAlarmName.setText(bundle_dialog_label.getString("dialog.charge_alert.alarm_name_title"));
		new Label(container, SWT.NONE);
		
		txtAlarmName = new Text(container, SWT.BORDER);
		txtAlarmName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblDescription = new Label(container, SWT.NONE);
		lblDescription.setAlignment(SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(bundle_dialog_label.getString("dialog.charge_alert.description_title"));

		new Label(container, SWT.NONE);
		
		txtDescription = new Text(container, SWT.BORDER);
		txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNewLabel_1 = new Label(container, SWT.NONE);
		GridData gd_lblNewLabel_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblNewLabel_1.widthHint = 84;
		lblNewLabel_1.setLayoutData(gd_lblNewLabel_1);
		lblNewLabel_1.setAlignment(SWT.RIGHT);
		lblNewLabel_1.setText(bundle_dialog_label.getString("dialog.charge_alert.target_title"));
		new Label(container, SWT.NONE);
		
		cmbTarget = new Combo(container, SWT.READ_ONLY);
		GridData gd_cmbTarget = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_cmbTarget.widthHint = 426;
		cmbTarget.setLayoutData(gd_cmbTarget);
		
		Group group = new Group(container, SWT.NONE);
		group.setLayout(new GridLayout(4, false));
		group.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		group.setText(bundle_dialog_label.getString("dialog.charge_alert.group.judge_title"));
		
		Label lblInfoThreshold = new Label(group, SWT.NONE);
		lblInfoThreshold.setAlignment(SWT.RIGHT);
		GridData gd_lblInfoThreshold = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_lblInfoThreshold.widthHint = 77;
		lblInfoThreshold.setLayoutData(gd_lblInfoThreshold);
		lblInfoThreshold.setBackground(SWTResourceManager.getColor(SWT.COLOR_GREEN));
		lblInfoThreshold.setText(bundle_dialog_label.getString("dialog.charge_alert.threshold_info_title"));
		new Label(group, SWT.NONE);
		
		txtThresholdInfoLimit = new Text(group, SWT.BORDER | SWT.RIGHT);
		txtThresholdInfoLimit.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = txtThresholdInfoLimit.getText().substring(0, e.start) + e.text + txtThresholdInfoLimit.getText().substring(e.start);
					if (t.length() != 0) {
						Double.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});
		GridData gd_txtThresholdInfoLimit = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_txtThresholdInfoLimit.widthHint = 50;
		txtThresholdInfoLimit.setLayoutData(gd_txtThresholdInfoLimit);
		
		Label label = new Label(group, SWT.NONE);
		label.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		label.setText(bundle_dialog_label.getString("dialog.charge_alert.threshold_info_description"));
		
		Label lblWarnThreshold = new Label(group, SWT.NONE);
		lblWarnThreshold.setAlignment(SWT.RIGHT);
		lblWarnThreshold.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblWarnThreshold.setBackground(SWTResourceManager.getColor(SWT.COLOR_YELLOW));
		lblWarnThreshold.setText(bundle_dialog_label.getString("dialog.charge_alert.threshold_warn_title"));
		new Label(group, SWT.NONE);
		
		txtThresholdWarnLimit = new Text(group, SWT.BORDER | SWT.RIGHT);
		txtThresholdWarnLimit.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent e) {
				try {
					String t = txtThresholdWarnLimit.getText().substring(0, e.start) + e.text + txtThresholdWarnLimit.getText().substring(e.start);
					if (t.length() != 0) {
						Double.valueOf(t);
					}
				}
				catch(Exception e1) {
					e.doit = false;
				}
			}
		});
		GridData gd_txtThresholdWarnLimit = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_txtThresholdWarnLimit.widthHint = 50;
		txtThresholdWarnLimit.setLayoutData(gd_txtThresholdWarnLimit);
		
		Label label_1 = new Label(group, SWT.NONE);
		GridData gd_label_1 = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_label_1.widthHint = 327;
		label_1.setLayoutData(gd_label_1);
		label_1.setText(bundle_dialog_label.getString("dialog.charge_alert.threshold_warn_description"));
		
		Label lblAlert = new Label(group, SWT.NONE);
		lblAlert.setAlignment(SWT.RIGHT);
		lblAlert.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAlert.setText(bundle_dialog_label.getString("dialog.charge_alert.threshold_error_title"));
		lblAlert.setBackground(SWTResourceManager.getColor(SWT.COLOR_RED));
		new Label(group, SWT.NONE);
		
		Label lblNewLabel = new Label(group, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		lblNewLabel.setText(bundle_dialog_label.getString("dialog.charge_alert.threshold_error_description"));
		
		Group group_1 = new Group(container, SWT.NONE);
		group_1.setLayout(new GridLayout(1, false));
		group_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 3, 1));
		group_1.setText(bundle_dialog_label.getString("dialog.charge_alert.group.notify_title"));
		
				
		// 通知情報（通知ID，アプリケーションID）
		this.notifyInfo = new NotifyIdListComposite(group_1, SWT.NONE, true);
		notifyInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		btnValidFlg = new Button(container, SWT.CHECK);
		btnValidFlg.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 3, 1));
		btnValidFlg.setText(bundle_dialog_label.getString("dialog.charge_alert.enabling_description"));
		btnValidFlg.setSelection(true);
		
		// サービス名設定。
		for(String target: provider.getAllServiceName()){
			if ("Total".equals(target)) {
				cmbTarget.add(bundle_view_label.getString("view.billing_alarm.monitor_service.total"));
			}
			else {
				cmbTarget.add(target);
			}
		}
		if (cmbTarget.getItemCount() != 0) {
			cmbTarget.select(0);
		}
		
		ControlUtil.setRequired(new Control[]{txtAlarmId, txtAlarmName, txtDescription, txtThresholdInfoLimit, txtThresholdWarnLimit});
		
		if (input != null) {
			txtAlarmId.setText(input.getAlarmId());
			txtAlarmId.setEditable(false);
			txtAlarmName.setText(input.getAlarmName());
			txtDescription.setText(input.getDescription());
			for (String item: cmbTarget.getItems()) {
				if (item.equals(input.getTarget())) {
					cmbTarget.setText(input.getTarget());
					break;
				}
			}
			txtThresholdInfoLimit.setText(String.valueOf(input.getThresholdInfoLimit()));
			txtThresholdWarnLimit.setText(String.valueOf(input.getThresholdWarnLimit()));
			notifyInfo.setNotify(input.getNotifyRelationInfos());
			btnValidFlg.setSelection(input.getValidFlg());
			
			notifyInfo.setNotify(input.getNotifyRelationInfos());
		}
		
		return container;
	}

	public List<NotifyRelationInfo> getNotifyRelationInfoList() {
		return notifyRelationInfoList;
	}

	@Override
	protected void okPressed() {
		if("".equals(txtAlarmId.getText())
				|| "".equals(txtAlarmName.getText())
				|| "".equals(txtThresholdInfoLimit.getText())
				|| "".equals(txtThresholdWarnLimit.getText())
				|| "".equals(txtDescription.getText())
			){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}

		Double infoLimit = null;
		Double warnLimit = null;
		try {
			infoLimit = Double.valueOf(txtThresholdInfoLimit.getText());
			warnLimit = Double.valueOf(txtThresholdWarnLimit.getText());
		}
		catch (Exception e) {
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.billing_alarm.message.invalid_limit"));
			return;
		}
		
		modifyRequest = new ModifyBillingAlarmRequest();
		modifyRequest.setAlarmName(txtAlarmName.getText());
		modifyRequest.setDescription(txtDescription.getText());
		modifyRequest.setTarget(bundle_view_label.getString("view.billing_alarm.monitor_service.total").equals(cmbTarget.getText()) ? "Total": cmbTarget.getText());
		modifyRequest.setThresholdInfoLimit(Double.valueOf(txtThresholdInfoLimit.getText()));
		modifyRequest.setThresholdWarnLimit(Double.valueOf(txtThresholdWarnLimit.getText()));
		modifyRequest.setValidFlg(btnValidFlg.getSelection());

		String notifyGroupId = NotifyGroupIdGenerator.createNotifyGroupId(HinemosModuleConstant.MONITOR_AWS_BILLING, txtAlarmId.getText());
		notifyInfo.setNotifyGroupId(notifyGroupId);
		modifyRequest.setNotifyRelationInfos(notifyInfo.getNotify());
		
		createRequest = new CreateBillingAlarmRequest();
		createRequest.setAlarmId(txtAlarmId.getText());
		createRequest.setAlarmName(txtAlarmName.getText());
		createRequest.setDescription(txtDescription.getText());
		createRequest.setTarget(bundle_view_label.getString("view.billing_alarm.monitor_service.total").equals(cmbTarget.getText()) ? "Total": cmbTarget.getText());
		createRequest.setThresholdInfoLimit(infoLimit);
		createRequest.setThresholdWarnLimit(warnLimit);
		createRequest.setValidFlg(btnValidFlg.getSelection());

		notifyInfo.setNotifyGroupId(notifyGroupId);
		createRequest.setNotifyRelationInfos(notifyInfo.getNotify());

		setReturnCode(OK);
		close();
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(560, 550);
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("charge_alert"));
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}
	
	public ModifyBillingAlarmRequest getModifyRequest() {
		return modifyRequest;
	}
	
	public CreateBillingAlarmRequest getCreateRequest() {
		return createRequest;
	}

	public void setInput(IBillingAlarm input) {
		this.input = input;
	}
}