/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.Arrays;
import java.util.List;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.Snapshot;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog.IDialogBehavior;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog.Model;

public class CreateStorageBehavior implements IDialogBehavior {
	private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
	private MessageManager bundle_region = MessageManager.getInstance("region");
	private Model input;
	private CloudResourceProvider provider;
	private Combo comboRegion;
	private Combo comboAvailabilityZone;
	private Combo comboSnapshot;

	@Override
	public void setInput(Model input) {
		this.input = input;
		
		if (comboRegion == null) {
			return;
		}
		
		if (this.input.region != null) {
			for (String item: comboRegion.getItems()) {
				if (comboRegion.getData(item).equals(this.input.region)) {
					comboRegion.setText(item);
					break;
				}
			}
		}
	}

	@Override
	public void setProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	@Override
	public void setupVolumeName(Text volumeName) {}

	@Override
	public void setupSize(Text size, Combo unit) {}

	@Override
	public void setupRegion(Combo comboRegion) {
		this.comboRegion = comboRegion;
		comboRegion.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String region = (String)CreateStorageBehavior.this.comboRegion.getData(CreateStorageBehavior.this.comboRegion.getText());

				if (comboAvailabilityZone != null) {
					// アベイラビリティゾーンの入れ替え。
					List<AvailabilityZone> avs = provider.getAvailabilityZones(region);
					comboAvailabilityZone.removeAll();
					for (AvailabilityZone name: avs) {
						comboAvailabilityZone.add(name.getZoneName());
					}

					if (!avs.isEmpty()) {
						comboAvailabilityZone.select(0);
					}
				}

				if (comboSnapshot != null) {
					// スナップショットの入れ替え。
					comboSnapshot.removeAll();
					comboSnapshot.add("--- No Snapshot ---");
					
					// リージョン毎のスナップショットの情報は、スナップショットにフォーカスが入った時に動作する。
//					List<Snapshot> snapshots = provider.getSnapshots(region, Arrays.asList(new CloudResourceProvider.MultiValueFilter[0]));
//					for (Snapshot s: snapshots) {
//						String snapshotName = s.getSnapshotId() + " -- " + s.getDescription();
//						comboSnapshot.add(snapshotName);
//						comboSnapshot.setData(snapshotName, s);
//					}

					comboSnapshot.select(0);
				}
			}
		});

		for (String regionName: provider.getAllRegion()) {
			String regionLocaleName = bundle_region.getString(regionName);
			comboRegion.add(regionLocaleName);
			comboRegion.setData(regionLocaleName, regionName);
		}
		
		if (input != null && input.region != null) {
			for (String item: comboRegion.getItems()) {
				if (comboRegion.getData(item).equals(input.region)) {
					comboRegion.setText(item);
					break;
				}
			}
		}
		else {
			comboRegion.select(0);
		}
	}

	@Override
	public void setupAvailabilityZone(Combo comboAvailabilityZone) {
		this.comboAvailabilityZone = comboAvailabilityZone;

		if (comboRegion != null) {
			String region = (String)CreateStorageBehavior.this.comboRegion.getData(CreateStorageBehavior.this.comboRegion.getText());

			// アベイラビリティゾーンの入れ替え。
			List<AvailabilityZone> avs = provider.getAvailabilityZones(region);
			comboAvailabilityZone.removeAll();
			for (AvailabilityZone name: avs) {
				comboAvailabilityZone.add(name.getZoneName());
			}

			if (!avs.isEmpty()) {
				comboAvailabilityZone.select(0);
			}
		}
	}

	@Override
	public void setupSnapshot(Combo comboSnapshot) {
		this.comboSnapshot = comboSnapshot;

		comboSnapshot.add("--- No Snapshot ---");
		comboSnapshot.select(0);

		comboSnapshot.addFocusListener(new FocusAdapter() {
			@Override
			public void focusGained(FocusEvent e) {
				// "--- No Snapshot ---" しか登録されていない場合、現在選択されているリージョンから、スナップショットのリストを取得。
				if (CreateStorageBehavior.this.comboSnapshot.getItemCount() <= 1) {
					List<Snapshot> snapshots = provider.getSnapshots((String)comboRegion.getData(comboRegion.getText()), Arrays.asList(new Filter[0]));
					for (Snapshot s: snapshots) {
						String snapshotName = s.getSnapshotId() + " -- " + s.getDescription();
						CreateStorageBehavior.this.comboSnapshot.add(snapshotName);
						CreateStorageBehavior.this.comboSnapshot.setData(snapshotName, s);
					}
				}
			}
		});	
	}

	@Override
	public void setupVolumeType(Combo volumeType) {
		for (String volumeTypeName: provider.getAllVolumeType()) {
			String volumeTypeLocaleName = bundle_volume_type.getString(volumeTypeName);
			volumeType.add(volumeTypeLocaleName);
			volumeType.setData(volumeTypeLocaleName, volumeTypeName);
		}
		volumeType.select(0);
	}

	@Override
	public void setupIops(Combo Iops) {
	}
}