/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;


//import java.util.regex.Pattern;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.util.Messages;

public class RegistCommandDialog extends Dialog {		
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

//	private Shell shell;

	private Text txtJobId;
	private Text txtJobName;
	private Text txtArgument;
	private Text txtExecuteUser;
	private Combo cmbBehaviorInFailure;
	private Text txtRangeStart;
	private Text txtRangeEnd;
	private Text txtCommand;
	private Combo cmbScript;
	private Button rdoCommand;
	private Button rdoScript;
	
	private Button btnUploadScript;
	
	private TemplateJobUtil.TemplateJob input;
	private TemplateJobUtil.TemplateJob output;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public RegistCommandDialog(Shell parentShell){
		super(parentShell);
//		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.verticalSpacing = 10;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblJobId = new Label(container, SWT.RIGHT);
		lblJobId.setText(bundle_dialog_label.getString("dialog.regist_command.job_id_title"));

		txtJobId = new Text(container, SWT.BORDER);
		txtJobId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label lblJobName = new Label(container, SWT.RIGHT);
		lblJobName.setText(bundle_dialog_label.getString("dialog.regist_command.job_name_title"));

		txtJobName = new Text(container, SWT.BORDER);
		txtJobName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Composite commandTypeComposite = new Composite(container, SWT.NONE);
		GridLayout gl_commandTypeComposite = new GridLayout(3, false);
		commandTypeComposite.setLayout(gl_commandTypeComposite);
		commandTypeComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		rdoCommand = new Button(commandTypeComposite, SWT.RADIO);
		rdoCommand.setText(bundle_dialog_label.getString("dialog.regist_command.radio.command_title"));
		
		rdoScript = new Button(commandTypeComposite, SWT.RADIO);
		rdoScript.setText(bundle_dialog_label.getString("dialog.regist_command.radio.script_title"));
		new Label(commandTypeComposite, SWT.NONE);
		
		Group grpCommand = new Group(container, SWT.NONE);
		grpCommand.setLayout(new GridLayout(2, false));
		grpCommand.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		grpCommand.setText(bundle_dialog_label.getString("dialog.regist_command.group.command_title"));
		
		Label lblCommand = new Label(grpCommand, SWT.NONE);
		lblCommand.setText(bundle_dialog_label.getString("dialog.regist_command.command_title"));
		
		txtCommand = new Text(grpCommand, SWT.BORDER);
		txtCommand.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Group grpScript = new Group(container, SWT.NONE);
		grpScript.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		grpScript.setLayout(new GridLayout(2, false));
		grpScript.setText(bundle_dialog_label.getString("dialog.regist_command.group.script_title"));
		
		Label lblScript = new Label(grpScript, SWT.NONE);
		lblScript.setText(bundle_dialog_label.getString("dialog.regist_command.script_title"));
		
		cmbScript = new Combo(grpScript, SWT.READ_ONLY);
		GridData gd_cmbScript = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_cmbScript.widthHint = 100;
		cmbScript.setLayoutData(gd_cmbScript);

		new Label(grpScript, SWT.NONE);
		
		btnUploadScript = new Button(grpScript, SWT.NONE);
		btnUploadScript.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		btnUploadScript.setText(bundle_dialog_label.getString("dialog.regist_command.button.upload_script_title"));
		btnUploadScript.setEnabled(false);

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblArgument = new Label(container, SWT.RIGHT);
		lblArgument.setText(bundle_dialog_label.getString("dialog.regist_command.argument_title"));

		txtArgument = new Text(container, SWT.BORDER);
		txtArgument.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		Label lblExecuteUser = new Label(container, SWT.RIGHT);
		lblExecuteUser.setText(bundle_dialog_label.getString("dialog.regist_command.execute_user_title"));

		txtExecuteUser = new Text(container, SWT.BORDER);
		txtExecuteUser.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		Label lblBehavioreInFailure = new Label(container, SWT.RIGHT);
		lblBehavioreInFailure.setText(bundle_dialog_label.getString("dialog.regist_command.behavior_in_failure_title"));

		cmbBehaviorInFailure = new Combo(container, SWT.READ_ONLY);
		GridData gd_cmbBehaviorInFailure = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_cmbBehaviorInFailure.widthHint = 100;
		cmbBehaviorInFailure.setLayoutData(gd_cmbBehaviorInFailure);
		
		Label lblSuccessReturnRange = new Label(container, SWT.RIGHT);
		lblSuccessReturnRange.setText(bundle_dialog_label.getString("dialog.regist_command.success_return_range_title"));

		Composite rangeComposite = new Composite(container, SWT.NONE);
		GridLayout gl_rangeComposite = new GridLayout(3, false);
		gl_rangeComposite.marginWidth = 0;
		rangeComposite.setLayout(gl_rangeComposite);
		rangeComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		txtRangeStart = new Text(rangeComposite, SWT.BORDER);
		txtRangeStart.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		Label delimiter = new Label(rangeComposite, SWT.NONE);
		delimiter.setText("-");
		
		txtRangeEnd = new Text(rangeComposite, SWT.BORDER);
		txtRangeEnd.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		// 項目名の幅をグループ間で一致させる。
		container.layout(true);
		
		int rightColumnStart = txtJobId.getBounds().x;
		int leftColumnStart = lblCommand.getBounds().x;
		int width = rightColumnStart - leftColumnStart - 10;

		((GridData)lblCommand.getLayoutData()).widthHint = width;
		((GridData)lblScript.getLayoutData()).widthHint = width;
		
		container.layout(true);

		//必須設定
		Control[] requiredControls = new Control[]{
			txtJobId,
			txtJobName,
			txtCommand,
			cmbScript,
			txtExecuteUser,
			txtRangeStart,
			txtRangeEnd
		};
		ControlUtil.setRequired(requiredControls);
		
		//数値のみ入力可能にする
		Text[] texts = new Text[]{
			txtRangeStart,
			txtRangeEnd
		};
//		ControlUtil.setInputRestriction(texts, Pattern.compile("^-?[0-9]+$"));
		ControlUtil.setDigitOnlyInput(texts);
		
		//初期値
		rdoCommand.setSelection(true);
		cmbScript.setEnabled(false);
		cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		
		try {
			for(String script: TemplateJobUtil.getTemplateScripts()){
				cmbScript.add(script);
				cmbScript.setData(script, script);
			}
		} catch (Exception e) {
		}
		
		for(TemplateJobUtil.BehaviorInFailure behavior: TemplateJobUtil.BehaviorInFailure.values()){
			cmbBehaviorInFailure.add(behavior.toString());
			cmbBehaviorInFailure.setData(behavior.toString(), behavior);
		}
		cmbBehaviorInFailure.select(0);
		
		if(input != null){
			if(input.getJobId() != null && !input.getJobId().equals("")){
				txtJobId.setText(input.getJobId());
			}
			if(input.getJobName() != null && !input.getJobName().equals("")){
				txtJobName.setText(input.getJobName());
			}
			if(input.getCommandType() != null && input.getCommandType().equals(TemplateJobUtil.CommandType.command)){
				txtCommand.setEnabled(true);
				cmbScript.setEnabled(false);
//				btnUploadScript.setEnabled(false);
				
				rdoCommand.setSelection(true);
				rdoScript.setSelection(false);
				if(input.getCommand() != null && !input.getCommand().equals("")){
					txtCommand.setText(input.getCommand());
				}
				if(txtCommand.getText().equals("")){
					txtCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				
				cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			} else if(input.getCommandType() != null && input.getCommandType().equals(TemplateJobUtil.CommandType.script)){
				cmbScript.setEnabled(true);
//				btnUploadScript.setEnabled(true);
				txtCommand.setEnabled(false);
				rdoCommand.setSelection(false);
				rdoScript.setSelection(true);
				if(input.getCommand() != null && !input.getCommand().equals("")){
					cmbScript.select(cmbScript.indexOf(input.getCommand()));
				}
				txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);

				if(cmbScript.getText().equals("") || cmbScript.indexOf(cmbScript.getText()) == -1){
					cmbScript.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
			if(input.getArgument() != null && !input.getArgument().equals("")){
				txtArgument.setText(input.getArgument());
			}
			if(input.getExecuteUser() != null && !input.getExecuteUser().equals("")){
				txtExecuteUser.setText(input.getExecuteUser());
			}
			if(input.getBehaviorInFailure() != null){
				cmbBehaviorInFailure.select(cmbBehaviorInFailure.indexOf(input.getBehaviorInFailure().toString()));
			}
			if(input.getSuccessRangeStartValue() != null){
				txtRangeStart.setText(input.getSuccessRangeStartValue().toString());
			}
			if(input.getSuccessRangeEndValue() != null){
				txtRangeEnd.setText(input.getSuccessRangeEndValue().toString());
			}
		}
		
		rdoCommand.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				txtCommand.setEnabled(true);
				cmbScript.setEnabled(false);
//				btnUploadScript.setEnabled(false);
				
				if(txtCommand.getText().equals("")){
					txtCommand.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				
				cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
			}
		});
		
		rdoScript.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				if(cmbScript.getItemCount() < 1){
					MessageDialog.openError(null, Messages.getString("failed"), bundle_messages.getString("dialogs.common_scripts_do_not_exist"));
					rdoScript.setSelection(false);
					rdoCommand.setSelection(true);
					return;
				}
				cmbScript.setEnabled(true);
//				btnUploadScript.setEnabled(true);
				txtCommand.setEnabled(false);

				txtCommand.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);

				if(cmbScript.getText().equals("") || cmbScript.indexOf(cmbScript.getText()) == -1){
					cmbScript.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
				} else {
					cmbScript.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
			}
		});

//		btnUploadScript.addSelectionListener(new SelectionAdapter(){
//			@Override
//			public void widgetSelected(SelectionEvent e) {
//				if (dialog.open() == Window.OK) {
//				}
//			}
//		});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(480, 640);
	}

	@Override
	protected void okPressed() {
		if(
			txtJobId.getText().equals("") 
			|| txtJobName.getText().equals("")
			|| (!rdoCommand.getSelection() && !rdoScript.getSelection())
			|| (rdoCommand.getSelection() && txtCommand.getText().equals(""))
			|| (rdoScript.getSelection() && cmbScript.getText().equals(""))
//			|| txtArgument.getText().equals("")
			|| txtExecuteUser.getText().equals("")
			|| cmbBehaviorInFailure.getText().equals("")
			|| txtRangeStart.getText().equals("")
			|| txtRangeEnd.getText().equals("")
		){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}

		if(rdoScript.getSelection() && cmbScript.getData(cmbScript.getText()) == null){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.invalid_parameter_exists"));
			return;
		}
		
		try{
			if(Integer.parseInt(txtRangeStart.getText()) > Integer.parseInt(txtRangeEnd.getText())){
				String label = bundle_dialog_label.getString("dialog.regist_command.success_return_range_title");
				MessageDialog.openError(null,
						Messages.getString("failed"),
						bundle_messages.getString("dialogs.invalid_digit_order", new Object[]{"「" + label + "(1)」", "「" + label + "(2)」"}));
				return;
			}
		} catch(NumberFormatException e){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.invalid_parameter_exists"));
			return;
		}
		
		output = new TemplateJobUtil.TemplateJob();
		output.setJobId(txtJobId.getText());
		output.setJobName(txtJobName.getText());
		if(rdoCommand.getSelection()){
			output.setCommandType(TemplateJobUtil.CommandType.command);
			output.setCommand(txtCommand.getText());
		} else if(rdoScript.getSelection()){
			output.setCommandType(TemplateJobUtil.CommandType.script);
			output.setCommand((String)cmbScript.getData(cmbScript.getText()));
		} else {
			throw new IllegalStateException();
		}
		if(!txtArgument.getText().equals("")){
			output.setArgument(txtArgument.getText());
		}
		output.setExecuteUser(txtExecuteUser.getText());
		output.setBehaviorInFailure((TemplateJobUtil.BehaviorInFailure)cmbBehaviorInFailure.getData(cmbBehaviorInFailure.getText()));
		try{
			output.setSuccessRangeStartValue(Integer.parseInt(txtRangeStart.getText()));
			output.setSuccessRangeEndValue(Integer.parseInt(txtRangeEnd.getText()));
		} catch(NumberFormatException e){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.invalid_parameter_exists"));
			return;
		}
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("regist_command"));
	}

	public void setInput(TemplateJobUtil.TemplateJob input) {
		this.input = input;
	}

	public TemplateJobUtil.TemplateJob getOutput() {
		return output;
	}
}
