/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.io.Serializable;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.aws.presenter.RegistNodeRequest;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class RegistNodeDialog extends Dialog {
	public static class Model extends RegistNodeRequest implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = -2084659201305900110L;

		public Model deepCopy() {
			return (Model)super.deepCopy();
		}
	}
	
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private Text facilityName;
	private Text facilityId;
	private Text description;
	private Text nodeName;
	
	private Model input;
	private Model output = new Model();

	private Button btnNewButton;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public RegistNodeDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Group group = new Group(container, SWT.NONE);
		group.setText(bundle_dialog_label.getString("dialog.regist_node.group.node_info_title"));
		group.setLayout(new GridLayout(2, false));
		group.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

		Label lblid = new Label(group, SWT.NONE);
		lblid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblid.setText(bundle_dialog_label.getString("dialog.regist_node.facility_id_title"));

		facilityId = new Text(group, SWT.BORDER);
		facilityId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(group, SWT.NONE);
		
		btnNewButton = new Button(group, SWT.CHECK);
		btnNewButton.setText(bundle_dialog_label.getString("dialog.regist_node.node_replace_description"));

		Label lblFacilityName = new Label(group, SWT.NONE);
		lblFacilityName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFacilityName.setText(bundle_dialog_label.getString("dialog.regist_node.facility_name_title"));

		facilityName = new Text(group, SWT.BORDER);
		facilityName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);

		Label label = new Label(group, SWT.NONE);
		label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		label.setText(bundle_dialog_label.getString("dialog.regist_node.description_title"));

		description = new Text(group, SWT.BORDER);
		description.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);

		Label label_1 = new Label(group, SWT.NONE);
		label_1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		label_1.setText(bundle_dialog_label.getString("dialog.regist_node.node_name_title"));

		nodeName = new Text(group, SWT.BORDER);
		GridData gd_nodeName = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_nodeName.widthHint = 66;
		nodeName.setLayoutData(gd_nodeName);


		if (input != null) {
			if (input.getFacilityId() != null) {
				facilityId.setText(input.getFacilityId());
			}
			
			if (input.getFacilityName() != null) {
				facilityName.setText(input.getFacilityName());
			}
			
			if (input.getDescription() != null) {
				description.setText(input.getDescription());
			}
			
			if (input.getNodeName() != null) {
				nodeName.setText(input.getNodeName());
			}
			
			btnNewButton.setSelection(input.isReplaceNode());
		}

		ControlUtil.setRequired(new Control[]{facilityId, facilityName, nodeName});
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 360);
	}

	@Override
	protected void okPressed() {
		if(
			facilityId.getText() == ""
			|| facilityName.getText() == ""
			|| nodeName.getText() == ""
		){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("dialogs.must_fully_input"));
			return;
		}
		
		output = new Model();
		output.setFacilityId(facilityId.getText());
		output.setFacilityName(facilityName.getText());
		output.setDescription(description.getText());
		output.setNodeName(nodeName.getText());
		output.setReplaceNode(btnNewButton.getSelection());

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("regist_node"));
	}

	public void setInput(Model input) {
		assert input != null;
		this.input = input;
	}

	public RegistNodeDialog.Model getOutput() {
		return output;
	}
}
