/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.List;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog.IDialogBehavior;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog.Model;

public class RestoreStorageBehavior implements IDialogBehavior {
	private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
	private MessageManager bundle_region = MessageManager.getInstance("region");
	private static final String TERA_BYTE = "TiB";
	private static final Boolean REGION_ENABLED = false;
	private static final Boolean SNAPSHOT_ENABLED = false;
	
	private IStorageBackup backup;
	private Model input;
	private CloudResourceProvider provider;

	public RestoreStorageBehavior(IStorageBackup backup) {
		this.backup = backup;
	}
	
	@Override
	public void setInput(Model input) {
		this.input = input;
	}

	@Override
	public void setProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	@Override
	public void setupVolumeName(Text volumeName) {
		if(input.getStorageName() != null){
			volumeName.setText(input.getStorageName());			
		}
	}

	@Override
	public void setupSize(Text size, Combo unit) {
		if(input.getStorageSize() % 1024 == 0 && input.getStorageSize() / 1024 > 0){
			size.setText(String.valueOf(input.getStorageSize() / 1024));
			unit.select(unit.indexOf(TERA_BYTE));
		} else {
			size.setText(String.valueOf(input.getStorageSize()));
		}
	}

	@Override
	public void setupRegion(Combo region) {
		String regionLocaleName = bundle_region.getString(input.region);
		region.add(regionLocaleName);
		region.setData(regionLocaleName, input.region);
		
		region.select(0);
		
		region.setEnabled(REGION_ENABLED);
	}

	@Override
	public void setupAvailabilityZone(Combo availabilityZone) {
		List<AvailabilityZone> avs = provider.getAvailabilityZones(input.region);
		availabilityZone.removeAll();
		for (AvailabilityZone name: avs) {
			availabilityZone.add(name.getZoneName());
		}
		availabilityZone.select(availabilityZone.indexOf(input.getAvailabilityZone()));
	}

	@Override
	public void setupSnapshot(Combo snapshot) {
//		CloudResourceProvider.MultiValueFilter filter = new CloudResourceProvider.MultiValueFilter("snapshot-id", Arrays.asList(input.getSnapshotId()));
//		List<Snapshot> snapshots = provider.getSnapshots(input.region, Arrays.asList(filter));
//		if (snapshots.isEmpty()) {
//			throw new IllegalStateException();
//		}
		
		String snapshotName = input.getSnapshotId() + " -- " + backup.getDescription();
		snapshot.add(snapshotName);
		snapshot.setData(snapshotName, input.getSnapshotId());
		snapshot.select(0);
		snapshot.setEnabled(SNAPSHOT_ENABLED);
	}

	@Override
	public void setupVolumeType(Combo volumeType) {
		for (String volumeTypeName: provider.getAllVolumeType()) {
			String volumeTypeLocaleName = bundle_volume_type.getString(volumeTypeName);
			volumeType.add(volumeTypeLocaleName);
			volumeType.setData(volumeTypeLocaleName, volumeTypeName);
		}
		volumeType.select(0);
	}

	@Override
	public void setupIops(Combo Iops) {
	}
}
