/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class SelectAMIDialog2 extends Dialog {
	private Text filter;
	private List ami;
	private Button btnSearch;

	private String region;

	private CloudResourceProvider provider;
	
	private Image output;
	
	private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
	private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	/**
	 * Create the dialog.				// リージョンを取得する。

	 * @param parentShell
	 */
	public SelectAMIDialog2(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayout(new GridLayout(3, false));
		container.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Label lblTestfilter = new Label(container, SWT.NONE);
		lblTestfilter.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblTestfilter.setText(bundle_dialog_label.getString("dialog.select_ami.filter_title"));
		
		filter = new Text(container, SWT.BORDER);
		filter.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		btnSearch = new Button(container, SWT.NONE);
		btnSearch.setText(bundle_dialog_label.getString("dialog.select_ami.button.search_ami_title"));
		btnSearch.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(filter.getText() == ""){
					MessageDialog.openWarning(null, Messages.getString("failed"), bundle_messages.getString("dialogs.must_input_search_text"));
					return;
				}
				ami.removeAll();

				Filter f1 = new Filter();
				f1.setName("name");
				f1.setValues(Arrays.asList("*"+filter.getText()+"*"));
				Filter f2 = new Filter();
				f2.setName("image-type");
				f2.setValues(Arrays.asList("machine"));

				java.util.List<Filter> filters = new ArrayList<Filter>(Arrays.asList(f1, f2));
				java.util.List<Image> imgs = provider.getImages(region, filters);
				
				for (Image img: imgs) {
					String itemName = "("+img.getImageId()+") "+img.getName();
					ami.add(itemName);
					ami.setData(itemName, img);
				}
			}			
		});
		
		Label lblAmiList = new Label(container, SWT.NONE);
		lblAmiList.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		lblAmiList.setText(bundle_dialog_label.getString("dialog.select_ami.ami_list_title"));
		
		ami = new List(container, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		GridData gd_ami = new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1);
		gd_ami.heightHint = 303;
		gd_ami.widthHint = 469;
		ami.setLayoutData(gd_ami);

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if (ami.getSelection().length == 0) {
			MessageDialog.openError(null, Messages.getString("failed"), bundle_messages.getString("dialogs.must_select_ami"));
			return;
		}

		output = (Image)ami.getData(ami.getSelection()[0]);
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_dialog_name.getString("select_ami"));
	}
	
	public Image getOutput() {
		return output;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}
}