/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;

public class VolumeProvider {
	public static MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
	
	private VolumeContentProvider vcp;
	private VolumeLabelProvider vlp;
	
	public VolumeProvider(){
		this.vcp = new VolumeContentProvider();
		this.vlp = new VolumeLabelProvider();
	}
	
	public class VolumeContentProvider implements IStructuredContentProvider {
		@Override
		public Object[] getElements(Object inputElement) {
			return ((java.util.List<?>)inputElement).toArray();
		}
		@Override
		public void dispose() {
		}
		@Override
		public void inputChanged(Viewer viewer,	Object oldInput, Object newInput) {
		}
	}
	
	public class VolumeLabelProvider extends LabelProvider implements ITableLabelProvider {
		@Override
		public String getColumnText(Object element, int columnIndex) {
			IStorage storage = (IStorage)element;
			Boolean b1 = false;
			Boolean b2 = false;
			if(storage.getStorageAttachment() != null){
				b1 = true;
				Pattern p = Pattern.compile(AvailableDevice.ROOT_DEVICE+".*");
				Matcher m = p.matcher(storage.getStorageAttachment().getDevice());
				if(m.find()){
					b2 = true;
				}
			}
			switch(columnIndex) {
				case 0:
					return storage.getStorageId();
				case 1:
					return storage.getStorageName();
				case 2:
					return b2? "Root" : "EBS";
				case 3:
					return b1? (storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice(): "") : "";
				case 4:
					return storage.getSnapshotId() != null ? storage.getSnapshotId(): "";
				case 5:
					return storage.getSize() != null ? String.valueOf(storage.getSize()): null;
				case 6:
					return storage.getStorageKind() != null ? bundle_volume_type.getString(storage.getStorageKind()): null;
				case 7:
					return storage.getIops() != null? String.valueOf(storage.getIops()) : "";
				}
			return null;
		}
		@Override
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}
	}

	public VolumeContentProvider getVolumeContentProvider(){
		return this.vcp;
	}

	public VolumeLabelProvider getVolumeLabelProvider(){
		return this.vlp;
	}
}
