/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarm;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarmService;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.commons.util.MessageManager;


/**
 */
public class BillingAlarmsView extends ViewPart {
	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		super.dispose();
	}

	public static final String Id = "com.clustercontrol.cloud.ui.views.BillingAlarmsView";

	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
	
	private Table table;
	private TableViewer tableViewer;
	private Label lblFooder;
	private IBillingAlarmService billingAlarmService = null;
	private List<IBillingAlarm> billingAlarms; 
	private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
	private String footerTitle = bundle_view_label.getString("view.billing_alarm.footer_title");

	private CollectionObserver2<IBillingAlarm> elementObserver = new CollectionObserver2<IBillingAlarm>() {
		@Override
		public void elementAdded(ElementAddedEvent<IBillingAlarm> event) {
			event.getAddedElement().addPropertyObserver2(IElement.allProperty, propertyObserver);

			billingAlarms.add(event.getAddedElement());
			tableViewer.setInput(billingAlarms);

			lblFooder.setText(footerTitle + billingAlarms.size());

			BillingAlarmsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = BillingAlarmsView.this.tableViewer.getSelection();
					BillingAlarmsView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		@Override
		public void elementRemoved(ElementRemovedEvent<IBillingAlarm> event) {
			event.getRemovedElement().removePropertyObserver2(IElement.allProperty, propertyObserver);

			billingAlarms.remove(event.getRemovedElement());
			tableViewer.setInput(billingAlarms);
			
			lblFooder.setText(footerTitle + billingAlarms.size());

			BillingAlarmsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = BillingAlarmsView.this.tableViewer.getSelection();
					BillingAlarmsView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};

	private AllPropertyObserver propertyObserver = new AllPropertyObserver() {
		@Override
		public void propertyChanged(ValueChangedEvent event) {
			BillingAlarmsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = BillingAlarmsView.this.tableViewer.getSelection();
					BillingAlarmsView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementRemoved(ElementRemovedEvent event) {
			BillingAlarmsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = BillingAlarmsView.this.tableViewer.getSelection();
					BillingAlarmsView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
		
		@Override
		public void elementAdded(ElementAddedEvent event) {
			BillingAlarmsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					tableViewer.refresh(true);

					// アクションの状態を更新。
					ISelection selection = BillingAlarmsView.this.tableViewer.getSelection();
					BillingAlarmsView.this.getSite().getSelectionProvider().setSelection(selection);
				}
			});
		}
	};
	
 	public BillingAlarmsView() {
	}

 	@Override
	public void createPartControl(Composite arg0) {
		Composite composite = new Composite(arg0, SWT.NONE);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
		tblclmnNewColumn.setText(bundle_view_label.getString("view.billing_alarm.column.alarm_id"));
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getAlarmId();
			}
		});
		
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.billing_alarm.column.alarm_name"));
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getAlarmName();
			}
		});

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.billing_alarm.column.cloud_id"));
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getCloudId();
			}
		});

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.billing_alarm.column.cloud_user_id"));
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getCloudUserId();
			}
		});

		TableViewerColumn tableViewerColumn_12 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_12 = tableViewerColumn_12.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_12, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_12.setText(bundle_view_label.getString("view.billing_alarm.column.description"));
		tableViewerColumn_12.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getDescription();
			}
		});

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_4, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_4.setText(bundle_view_label.getString("view.billing_alarm.column.target"));
		tableViewerColumn_4.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				IBillingAlarm billingAlarm = (IBillingAlarm)element;
				return "Total".equals(billingAlarm.getTarget()) ? bundle_view_label.getString("view.billing_alarm.monitor_service.total"): billingAlarm.getTarget();
			}
		});

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_5, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_5.setText(bundle_view_label.getString("view.billing_alarm.column.threshold_info_limit"));
		tableViewerColumn_5.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return String.valueOf(((IBillingAlarm)element).getThresholdInfoLimit());
			}
		});

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_6, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_6.setText(bundle_view_label.getString("view.billing_alarm.column.threshold_warn_limit"));
		tableViewerColumn_6.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return String.valueOf(((IBillingAlarm)element).getThresholdWarnLimit());
			}
		});

		TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_7, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_7.setText(bundle_view_label.getString("view.billing_alarm.column.reg_date"));
		tableViewerColumn_7.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getRegDate() != null ? format.format(((IBillingAlarm)element).getRegDate().getTime()): null;
			}
		});

		TableViewerColumn tableViewerColumn_8 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_8 = tableViewerColumn_8.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_8, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_8.setText(bundle_view_label.getString("view.billing_alarm.column.update_date"));
		tableViewerColumn_8.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getUpdateDate() != null ? format.format(((IBillingAlarm)element).getUpdateDate().getTime()): null;
			}
		});

		TableViewerColumn tableViewerColumn_9 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_9 = tableViewerColumn_9.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_9, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_9.setText(bundle_view_label.getString("view.billing_alarm.column.reg_user"));
		tableViewerColumn_9.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getRegUser();
			}
		});

		TableViewerColumn tableViewerColumn_10 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_10 = tableViewerColumn_10.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_10, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_10.setText(bundle_view_label.getString("view.billing_alarm.column.update_user"));
		tableViewerColumn_10.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IBillingAlarm)element).getUpdateUser();
			}
		});

		TableViewerColumn tableViewerColumn_11 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_11 = tableViewerColumn_11.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_11, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_11.setText(bundle_view_label.getString("view.billing_alarm.column.valid_flg"));
		tableViewerColumn_11.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				if (Boolean.TRUE.equals(((IBillingAlarm)element).getValidFlg())) {
					return bundle_view_label.getString("view.billing_alarm.valid");
				}
				else if (Boolean.FALSE.equals(((IBillingAlarm)element).getValidFlg())) {
					return bundle_view_label.getString("view.billing_alarm.invalid");
				}
				return null;
			}
		});

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooder = new Label(composite, SWT.NONE);
		lblFooder.setAlignment(SWT.RIGHT);
		lblFooder.setSize(lblFooder.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooder.setLayoutData(gridData);
		
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		try {
			update();
		}
		catch (Throwable e) {
			lblFooder.setText(footerTitle + 0);
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
		}
	}

	private List<IBillingAlarm> getBillingAlarms() {
		if (billingAlarms == null) {
			try {
				billingAlarmService = Activator.getDefault().getCloudManager().getInventory().getFolder(IBillingAlarmService.class);
				billingAlarmService.addPropertyObserver2(IBillingAlarmService.p2.billingAlarms, elementObserver);
				for (IBillingAlarm ba: billingAlarmService.getBillingAlarms()) {
					ba.addPropertyObserver2(IElement.allProperty, propertyObserver);
				}
				
				billingAlarms = new ArrayList<IBillingAlarm>();
				billingAlarms.addAll(Arrays.asList(billingAlarmService.getBillingAlarms()));
			}
			catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				billingAlarms = new ArrayList<IBillingAlarm>();
			}
		}
		
		return billingAlarms;
	}
 	
	public void update() {
		if (billingAlarms != null) {
			for (IBillingAlarm alarm: billingAlarms) {
				alarm.removePropertyObserver2(IElement.allProperty, propertyObserver);
			}
			billingAlarms = null;
		}

		if (billingAlarmService != null) {
			billingAlarmService.removePropertyObserver2(IBillingAlarmService.p2.billingAlarms, elementObserver);
			billingAlarmService.update();
		}

		List<IBillingAlarm> billingAlarms = getBillingAlarms();
		tableViewer.setInput(billingAlarms);
		lblFooder.setText(footerTitle + billingAlarms.size());
	}

	@Override
	public void setFocus() {
		tableViewer.getControl().setFocus();
	}
	
	public IBillingAlarmService getBillingAlarmService() {
		return billingAlarmService;
	}
}