/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IElement;
import com.clustercontrol.cloud.aws.presenter.INode;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.cloud.commons.util.MessageManager;

public abstract class FilterlingViewPartByScopeTree<R extends IElement, E extends IElement , M> extends FilterlingViewPart<IRegion, R, E, M> implements ISelectionListener {
	private MessageManager bundle_region = MessageManager.getInstance("region");
	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");

	private String zoneName;
	private String facilityId;
	
	protected Map<IRegion, String> resultMap = new HashMap<IRegion, String>();

	@Override
	protected boolean prepareFilterConditiion(String viweId, ISelection selection) {
		if (!viweId.equals(ScopeView.Id)) {
			return false;
		}
		
		if (!(selection instanceof IStructuredSelection)) {
			return false;
		}

		IStructuredSelection sselection = (IStructuredSelection)selection;
		if (sselection.isEmpty()) {
			return false;
		}
		
//		try {
			Object selected = sselection.getFirstElement();
			if (selected instanceof IScope) {
				IScope scope = (IScope)selected;
				
				switch(scope.getScopeType()) {
				case root:
					{
						setNextState(null);
						zoneName = null;
						facilityId = null;
					}
					break;
				case region:
					{
						IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
						setNextState(ec2Service.getRegion(scope.getFacilityId()));
						zoneName = null;
						facilityId = null;
					}
					break;
				case availabilityZone:
					{
						IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
						setNextState(ec2Service.getRegion(scope.getParent().getFacilityId()));
						zoneName = scope.getFacilityId();
						facilityId = null;
					}
					break;
				default:
					return false;
				}
			}
			else if (selected instanceof INode) {
				INode node = (INode)selected;

				IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
				setNextState(ec2Service.getRegion(node.getParent().getParent().getFacilityId()));
				zoneName = node.getParent().getFacilityId();
				facilityId = node.getFacilityId();
			}
//		}
//		catch (Exception e) {
//			Logger logger = Logger.getLogger(this.getClass());
//			logger.error(e.getMessage(), e);
//			
//			return false;
//		}
		
		return true;
	}

	protected String getHeaderByFacilityId(IRegion region, String facilityId) {
		return bundle_view_label.getString("view.instance.header_title3") + facilityId;
	}
	
	protected String getHeaderByAvailabilityZone(IRegion region, String availabilityZone) {
		return bundle_view_label.getString("view.instance.header_title2") + bundle_region.getString(region.getRegionName()) + ", " + availabilityZone;
	}
	
	protected String getHeaderByRegion(IRegion region) {
		return bundle_view_label.getString("view.instance.header_title") + bundle_region.getString(region.getRegionName());
	}

	protected String getEmptyHeader() {
		return "";
	}
	
	@Override
	protected void startGetManagerData(IRegion region) {
		getLeftFooter().setText(bundle_region.getString(region.getRegionName()) + " " + bundle_view_label.getString("view.viewing_status.under_access"));
	}

	@Override
	protected boolean isMatch(E element) {
		return getCurrentState() != null && isMatchRegion(getCurrentState(), element) &&
			(zoneName == null || isMatchAvailabilityZone(zoneName, element)) &&
			(facilityId == null || isMatchFacilityId(facilityId, element));
	}
	
	protected abstract boolean isMatchRegion(IRegion region, E element);

	protected abstract boolean isMatchAvailabilityZone(String zoneName, E element);

	protected abstract boolean isMatchFacilityId(String facilityId, E element);

	protected abstract Label getHeaderLabel();
	
	protected abstract Label getLeftFooter();
	
	protected abstract Label getRightFooter();

	@Override
	protected void failedPrepareFilterConditiion(Exception exception) {
		super.failedPrepareFilterConditiion(exception);
		
		getHeaderLabel().setText("");
		
		if (exception instanceof CloudModelException) {
			getLeftFooter().setText(((CloudModelException)exception).getMessage());
		}
		else {
			getLeftFooter().setText(bundle_view_label.getString("view.viewing_status.fail"));
		}

		getRightFooter().setText(bundle_view_label.getString("view.billing_alarm.footer_title") + getCurrentElements().size());
	}
	
	@Override
	protected void successGetManagerData(IRegion targetState, List<M> managerElements) {
		super.successGetManagerData(targetState, managerElements);
		resultMap.put(targetState, bundle_view_label.getString("view.viewing_status.success"));
	}

	@Override
	protected void failedGetManagerData(IRegion targetState, Exception exception) {
		super.failedGetManagerData(targetState, exception);
		resultMap.put(targetState, bundle_view_label.getString("view.viewing_status.fail"));
	}
	
	@Override
	protected void updateStatus() {
		if (getCurrentState() != null) {
			if (getActiveFacilityId() != null) {
				getHeaderLabel().setText(getHeaderByFacilityId(getCurrentState(), getActiveFacilityId()));
			}
			else if (getActiveZone() != null) {
				getHeaderLabel().setText(getHeaderByAvailabilityZone(getCurrentState(), getActiveZone()));
			}
			else {
				getHeaderLabel().setText(getHeaderByRegion(getCurrentState()));
			}
		}
		else {
			getHeaderLabel().setText(getEmptyHeader());
		}

		getLeftFooter().setText(resultMap.get(getCurrentState()) == null ? "": resultMap.get(getCurrentState()));

		getRightFooter().setText(bundle_view_label.getString("view.billing_alarm.footer_title") + getCurrentElements().size());
	}

	@Override
	protected void updateStatus(Exception exception) {
		if (getCurrentState() != null) {
			if (getActiveFacilityId() != null) {
				getHeaderLabel().setText(getHeaderByFacilityId(getCurrentState(), getActiveFacilityId()));
			}
			else if (getActiveZone() != null) {
				getHeaderLabel().setText(getHeaderByAvailabilityZone(getCurrentState(), getActiveZone()));
			}
			else {
				getHeaderLabel().setText(getHeaderByRegion(getCurrentState()));
			}
		}
		else {
			getHeaderLabel().setText(getEmptyHeader());
		}

		getLeftFooter().setText(resultMap.get(getCurrentState()) == null ? "": resultMap.get(getCurrentState()));

		getRightFooter().setText(bundle_view_label.getString("view.billing_alarm.footer_title") + getCurrentElements().size());
	}
	
	public IRegion getActiveRegion() {
		return getCurrentState();
	}
	
	public String getActiveZone() {
		return zoneName;
	}

	public String getActiveFacilityId() {
		return facilityId;
	}
	@Override
	public void update() {
		ISelection selection = getSite().getPage().getSelection(ScopeView.Id);
		update(new ConcreteDataHolder(ScopeView.Id, selection), true);
	}
}