///*
//Copyright (C) 2013 NTT DATA Corporation
//
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation, version 2.
//
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//PURPOSE.  See the GNU General Public License for more details.
// */
//package com.clustercontrol.cloud.ui.views;
//
//import java.util.ArrayList;
//import java.util.List;
//import java.util.MissingResourceException;
//import java.util.ResourceBundle;
//
//import org.eclipse.jface.layout.TableColumnLayout;
//import org.eclipse.jface.viewers.ColumnLabelProvider;
//import org.eclipse.jface.viewers.ColumnPixelData;
//import org.eclipse.jface.viewers.ISelection;
//import org.eclipse.jface.viewers.IStructuredContentProvider;
//import org.eclipse.jface.viewers.IStructuredSelection;
//import org.eclipse.jface.viewers.TableViewer;
//import org.eclipse.jface.viewers.TableViewerColumn;
//import org.eclipse.jface.viewers.Viewer;
//import org.eclipse.swt.SWT;
//import org.eclipse.swt.layout.GridData;
//import org.eclipse.swt.layout.GridLayout;
//import org.eclipse.swt.widgets.Composite;
//import org.eclipse.swt.widgets.Label;
//import org.eclipse.swt.widgets.Table;
//import org.eclipse.swt.widgets.TableColumn;
//import org.eclipse.ui.ISelectionListener;
//import org.eclipse.ui.IWorkbenchPart;
//import org.eclipse.ui.part.ViewPart;
//
//import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
//import com.clustercontrol.cloud.aws.presenter.IIpPermission;
//import com.clustercontrol.cloud.aws.presenter.ISecurityGroup;
//import com.clustercontrol.cloud.commons.util.MessageManager;
//
//
///**
// */
//public class SecurityGroupDetailView extends ViewPart implements ISelectionListener {
//	public SecurityGroupDetailView() {
//	}
//	public static final String Id = "com.clustercontrol.cloud.ui.views.SecurityGroupDetailView";
//
//	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
//	public static ResourceBundle bundle_tcp = ResourceBundle.getBundle("tcp");
//	public static ResourceBundle bundle_udp = ResourceBundle.getBundle("udp");
//	public static ResourceBundle bundle_icmp = ResourceBundle.getBundle("icmp");
//	
//	private Table table;
//	private TableViewer tableViewer;
//	private List<IIpPermission> ipPermissions = new ArrayList<IIpPermission>();
//	private Label lblHeader;
//	private Label lblFooter;
//	private ISecurityGroup sg;
//	private String headerTitle = bundle_view_label.getString("view.security_group_detail.header_title");
//	private String footerTitle = bundle_view_label.getString("view.security_group_detail.footer_title");
//	
//
//	private Runnable refreshness = new Runnable() {
//		@Override
//		public void run() {
//			ipPermissions = sg.getIpPermissions();
//			tableViewer.setInput(ipPermissions);
//			
//			// 非同期でコールバックが来るので更新。
//			tableViewer.refresh(true);
//			
//			// アクションの状態を更新。
//			ISelection selection = SecurityGroupDetailView.this.tableViewer.getSelection();
//			SecurityGroupDetailView.this.getSite().getSelectionProvider().setSelection(selection);
//		}
//	};
//
//	private CollectionObserver2<IIpPermission> ipPermissionsObserver = new CollectionObserver2<IIpPermission>() {
//		@Override
//		public void elementAdded(ElementAddedEvent<IIpPermission> event) {
//			SecurityGroupDetailView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
//		}
//		@Override
//		public void elementRemoved(ElementRemovedEvent<IIpPermission> event) {
//			SecurityGroupDetailView.this.getSite().getShell().getDisplay().asyncExec(refreshness);
//		}
//	};
//	
//	@Override
//	public void createPartControl(Composite arg0) {
//		
//		Composite composite = new Composite(arg0, SWT.NONE);
//		
//		lblHeader = new Label(composite, SWT.NONE);
//		lblHeader.setSize(lblHeader.getSize().x, 80);
//		GridData gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		lblHeader.setLayoutData(gridData);
//
//		Composite composite_1 = new Composite(composite, SWT.NONE);
//		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
//		composite_1.setLayout(tcl_composite_1);
//
//		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
//		table = tableViewer.getTable();
//		table.setHeaderVisible(true);
//		table.setLinesVisible(true);
//
//		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn.setText(bundle_view_label.getString("view.security_group_detail.column.protocol"));
//		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				return ((IIpPermission)element).getIpProtocol();
//			}
//		});
//		
//		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.security_group_detail.column.port"));
//		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				IIpPermission ip = (IIpPermission)element;
//				StringBuffer sb = new StringBuffer();
//				
//				if("icmp".equals(ip.getIpProtocol())){
//					sb.append(bundle_icmp.getString(String.valueOf(ip.getFromPort())));
//					try {
//						String str;
//						str = bundle_icmp.getString(String.valueOf(ip.getFromPort()) + "," + String.valueOf(ip.getToPort()));
//						sb.append("/" + str);
//					} catch (MissingResourceException e) {
//					}
//				} else {
//					if(!String.valueOf(ip.getFromPort()).equals(String.valueOf(ip.getToPort()))){
//						sb.append(String.valueOf(ip.getFromPort()) + " - " + String.valueOf(ip.getToPort()));
//					} else {
//						sb.append(String.valueOf(ip.getFromPort()));
//					}
//				}
//				
//				if("tcp".equals(ip.getIpProtocol())){
//					try {
//						String str;
//						str = bundle_tcp.getString(sb.toString());
//						sb.append(" (" + str + ")");
//					} catch (MissingResourceException e) {
//					}
//				} else if("udp".equals(ip.getIpProtocol())){
//					try {
//						String str;
//						str = bundle_udp.getString(sb.toString());
//						sb.append(" (" + str + ")");
//					} catch (MissingResourceException e) {
//					}
//				}
//								
//				return sb.toString();
//			}
//		});
//
//		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.security_group_detail.column.source"));
//		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				if("".equals(((IIpPermission)element).getIpRange()) || ((IIpPermission)element).getIpRange() == null){
//					return ((IIpPermission)element).getGroupName() + " ( " + ((IIpPermission)element).getSecurityGroupId() + " )";
//				} else {
//					return ((IIpPermission)element).getIpRange();
//				}
//			}
//		});
//
//		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
//		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
//		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
//		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.security_group_detail.column.in_out"));
//		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
//			@Override
//			public String getText(Object element) {
//				return ((IIpPermission)element).getDirectionToBound();
//			}
//		});
//		
//		this.getSite().setSelectionProvider(tableViewer);
//		
//		GridLayout gl_composite = new GridLayout(1, true);
//		gl_composite.horizontalSpacing = 0;
//		gl_composite.marginHeight = 0;
//		gl_composite.marginWidth = 0;
//		gl_composite.verticalSpacing = 0;
//		composite.setLayout(gl_composite);
//		gridData = new GridData();
//		gridData.horizontalAlignment = GridData.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		gridData.grabExcessHorizontalSpace = true;
//		gridData.grabExcessVerticalSpace = true;
//		composite_1.setLayoutData(gridData);
//
//		tableViewer.setContentProvider(new IStructuredContentProvider() {
//			@Override
//			public Object[] getElements(Object inputElement) {
//				Object[] objs =((List<?>) inputElement).toArray();
//				lblFooter.setText(footerTitle + objs.length);
//				return ((List<?>) inputElement).toArray();
//			}
//
//			@Override
//			public void dispose() {
//
//			}
//
//			@Override
//			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
//			}
//		});
//
//
//		lblFooter = new Label(composite, SWT.NONE);
//		lblFooter.setAlignment(SWT.RIGHT);
//		lblFooter.setSize(lblFooter.getSize().x, 80);
//		gridData = new GridData();
//		gridData.horizontalAlignment = SWT.FILL;
//		gridData.verticalAlignment = GridData.FILL;
//		lblFooter.setLayoutData(gridData);
//
//		tableViewer.setInput(ipPermissions);
//		getSite().getPage().addSelectionListener(this);
//	}
//
//	@Override
//	public void setFocus() {
//		tableViewer.getTable().forceFocus();
//	}
//
//
//	@Override
//	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
//		if (part instanceof SecurityGroupsView && selection instanceof IStructuredSelection) {
//			if (sg != null) {
//				sg.removePropertyObserver2(ISecurityGroup.p2.ipPermissions, ipPermissionsObserver);
//			}
//			sg = null;
//			if(((IStructuredSelection)selection).size() > 1){
//				lblHeader.setText(headerTitle);
//				ipPermissions.clear();
//			} else {
//				StringBuffer sb = new StringBuffer();
//				ipPermissions.clear();
//				for(Object sg: ((IStructuredSelection)selection).toList()){
//					ipPermissions.addAll(((ISecurityGroup)sg).getIpPermissions());
//					if(sb.length() > 0){
//						sb.append(", " + ((ISecurityGroup)sg).getSecurityGroupName());
//					} else {
//						sb.append(((ISecurityGroup)sg).getSecurityGroupName());					
//					}
//					this.sg = (ISecurityGroup)sg;
//					this.sg.addPropertyObserver2(ISecurityGroup.p2.ipPermissions, ipPermissionsObserver);
//				}
//				lblHeader.setText(headerTitle + sb.toString());
//			}
//			tableViewer.setInput(ipPermissions);
//			tableViewer.refresh();
//		
//			SecurityGroupDetailView.this.getSite().getSelectionProvider().setSelection(SecurityGroupDetailView.this.tableViewer.getSelection());
//		}
//	}
//
//	public ISecurityGroup getSecurityGroup(){
//		return sg;
//	}
//}
