/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.presenter.IStorageBackupRoot;
import com.clustercontrol.cloud.aws.presenter.InvalidStateException;
import com.clustercontrol.cloud.aws.presenter.PropertyId2;
import com.clustercontrol.cloud.aws.presenter.StorageBackupRoot;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudStorageBackup;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.ValidationFault_Exception;


/**
 */
public class StorageBackupView extends FilterlingViewPartByScopeTree2<IStorageBackupRoot, IStorageBackup, CloudStorageBackup> {
	public static final String Id = "com.clustercontrol.cloud.ui.views.StorageBackupView";

	private static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(3, 3, 60, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
	private MessageManager bundle_region = MessageManager.getInstance("region");
	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");
	
	private Table table;
	private TableViewer tableViewer;
	private Label lblHeader;
	private FooterComposite footerComposite;
	private SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");

	public StorageBackupView() {
	}

	@Override
	public void createPartControl(Composite arg0) {
		
		Composite composite = new Composite(arg0, SWT.NONE);
		
		lblHeader = new Label(composite, SWT.NONE);
		lblHeader.setSize(lblHeader.getSize().x, 80);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblHeader.setLayoutData(gridData);

		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn, new ColumnPixelData(100, true, true));
		tblclmnNewColumn.setText(bundle_view_label.getString("view.storage_backup.column.snapshot_id"));
		tableViewerColumn.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IStorageBackup)element).getSnapshotId();
			}
		});
		
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_1, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_1.setText(bundle_view_label.getString("view.storage_backup.column.snapshot_name"));
		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return ((IStorageBackup)element).getSnapshotName();
			}
		});

		TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_2, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_2.setText(bundle_view_label.getString("view.storage_backup.column.cloud_id"));
		tableViewerColumn_2.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IStorageBackup)element).getCloudId();
			}
		});

		TableViewerColumn tableViewerColumn_3 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_3 = tableViewerColumn_3.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_3, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_3.setText(bundle_view_label.getString("view.storage_backup.column.description"));
		tableViewerColumn_3.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IStorageBackup)element).getDescription();
			}
		});

		TableViewerColumn tableViewerColumn_4 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_4 = tableViewerColumn_4.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_4, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_4.setText(bundle_view_label.getString("view.storage_backup.column.volume_id"));
		tableViewerColumn_4.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IStorageBackup)element).getVolumeId();
			}
		});

		TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_5 = tableViewerColumn_5.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_5, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_5.setText(bundle_view_label.getString("view.storage_backup.column.exist_status"));
		tableViewerColumn_5.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					switch(((IStorageBackup)element).getExistsStatus()){
					case exist:
						return bundle_view_label.getString("view.storage_backup.exist");
					case nothing:
						return bundle_view_label.getString("view.storage_backup.nothing");
					default:
						throw new InvalidStateException();
					}
			}
		});

		TableViewerColumn tableViewerColumn_6 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_6 = tableViewerColumn_6.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_6, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_6.setText(bundle_view_label.getString("view.storage_backup.column.reg_date"));
		tableViewerColumn_6.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
				return format.format(((IStorageBackup)element).getRegDate());
			}
		});

		TableViewerColumn tableViewerColumn_7 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_7 = tableViewerColumn_7.getColumn();
		tcl_composite_1.setColumnData(tblclmnNewColumn_7, new ColumnPixelData(100, true, true));
		tblclmnNewColumn_7.setText(bundle_view_label.getString("view.storage_backup.column.reg_user"));
		tableViewerColumn_7.setLabelProvider(new ColumnLabelProvider(){
			@Override
			public String getText(Object element) {
					return ((IStorageBackup)element).getRegUser();
			}
		});

		this.getSite().setSelectionProvider(tableViewer);
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				return ((List<?>) inputElement).toArray();
			}

			@Override
			public void dispose() {

			}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
			}
		});

		footerComposite = new FooterComposite(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		footerComposite.setSize(lblHeader.getSize().x, 80);
		footerComposite.setLayoutData(gridData);

		getSite().getPage().addSelectionListener(this);
		getSite().setSelectionProvider(tableViewer);
		
		update();
	}

	@Override
	protected String getHeaderByElementId(IRegion region, List<String> elementIds) {
		if (!elementIds.isEmpty()) {
			return bundle_view_label.getString("view.instance.header_title") + bundle_region.getString(region.getRegionName()) + " " + bundle_view_label.getString("view.storage_backup.header_title2") + elementIds.get(0);
		}
		else {
			return bundle_view_label.getString("view.instance.header_title") + bundle_region.getString(region.getRegionName());
		}
	}
	@Override
	protected String getElementId(Object selected) {
		if (selected instanceof IStorage) {
			return ((IStorage)selected).getStorageId();
		}
		return null;
	}
	@Override
	protected boolean isMatchRegion(IRegion region, IStorageBackup element) {
		return region.getRegionName().equals(element.getRegion());
	}
	@Override
	protected boolean isMatchFacilityIds(List<String> elementIds, IStorageBackup element) {
		if (elementIds.isEmpty() || elementIds.size() > 1) {
			return false;
		}
		return element.getVolumeId().equals(elementIds.get(0));
	}
	@Override
	protected Label getHeaderLabel() {
		return lblHeader;
	}
	@Override
	protected Label getLeftFooter() {
		return footerComposite.getLeftControl();
	}
	@Override
	protected Label getRightFooter() {
		return footerComposite.getRightControl();
	}
	@Override
	protected String getSupportViewId() {
		return StoragesView2.Id;
	}
	@Override
	protected IStorageBackupRoot getRootElement(IRegion region) {
		return region.getBackupManagement().getStorageBackupRoot();
	}
	@Override
	protected List<IStorageBackup> getElements(IStorageBackupRoot root) {
		return Arrays.asList(root.getStorageBackups());
	}
	@Override
	protected PropertyId2<CollectionObserver2<IStorageBackup>> getPropertyId() {
		return IStorageBackupRoot.p2.storageBackups;
	}
	@Override
	protected List<CloudStorageBackup> getManagerElements(CloudEndpoint endpoint, IRegion target)  throws InvalidRole_Exception, InvalidUserPass_Exception, CloudManagerFault_Exception, ValidationFault_Exception {
		return endpoint.getStorageBackupsByRegion(target.getRegionName());
	}
	@Override
	protected void setManagerElements(IStorageBackupRoot rootElement, List<CloudStorageBackup> managerElements) {
		((StorageBackupRoot)rootElement).internalUpdate(managerElements);
	}
	@Override
	protected boolean isInitialized(IStorageBackupRoot rootElement) {
		return ((StorageBackupRoot)rootElement).isInitialized();
	}
	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}
	@Override
	protected ThreadPoolExecutor getExecutor() {
		return threadPool;
	}
}
