/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class AbstractViewAction implements IViewActionDelegate {
	protected IViewPart viewPart;

	@Override
	public void run(IAction action) {
		ErrorHandler handler = new ErrorHandler() {
			@Override
			protected void invoke(IAction action) throws InvocationException {
				AbstractViewAction.this.invoke(action);
			}
		};
		handler.execute(action);
	}

	protected abstract void invoke(IAction action) throws InvocationException;

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}
}
