/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IStorage.RegistStateType;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.AttachStorageDialog;
import com.clustercontrol.util.Messages;


public class AttachInstanceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.AttachStorage";
	
	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IStorage storage = (IStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		AttachStorageDialog dialog = new AttachStorageDialog(this.viewPart.getSite().getShell(), storage);

		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					bundle_messages.getString("views.actions.attach_storage_confirm") + "\n" + storage.getStorageId())){

				storage.attachInstance(dialog.getInstanceId(), dialog.getDeviceName());

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.attach_storage_result"));
			}
		}
	}

	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			IStorage storage = (IStorage)iter.next();
						
			if (storage.getStorageAttachment() != null || storage.getRegistState() == RegistStateType.deleted) {
				return false;
			}
		}
		
		return true;
	}
}