///*
//Copyright (C) 2013 NTT DATA Corporation
//
//This program is free software; you can redistribute it and/or
//Modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation, version 2.
//
//This program is distributed in the hope that it will be
//useful, but WITHOUT ANY WARRANTY; without even the implied
//warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//PURPOSE.  See the GNU General Public License for more details.
// */
//
//package com.clustercontrol.cloud.ui.views.actions;
//
//import org.eclipse.jface.action.ActionContributionItem;
//import org.eclipse.jface.action.IAction;
//import org.eclipse.jface.dialogs.MessageDialog;
//import org.eclipse.jface.viewers.ISelection;
//import org.eclipse.jface.viewers.IStructuredSelection;
//import org.eclipse.jface.window.Window;
//import org.eclipse.ui.ISelectionListener;
//import org.eclipse.ui.IViewPart;
//import org.eclipse.ui.IWorkbenchPart;
//
//import com.clustercontrol.cloud.Activator;
//import com.clustercontrol.cloud.aws.presenter.CreateSecurityGroupRequest;
//import com.clustercontrol.cloud.aws.presenter.IEC2Service;
//import com.clustercontrol.cloud.aws.presenter.INetworkSecurityRoot;
//import com.clustercontrol.cloud.aws.presenter.INode;
//import com.clustercontrol.cloud.aws.presenter.IScope;
//import com.clustercontrol.cloud.commons.util.MessageManager;
//import com.clustercontrol.cloud.ui.dialogs.CreateSecurityGroupDialog;
//import com.clustercontrol.cloud.ui.views.ScopeView;
//import com.clustercontrol.cloud.ui.views.SecurityGroupsView;
//import com.clustercontrol.util.Messages;
//
//
//public class CreateSecurityGroupAction extends AbstractViewAction implements ISelectionListener {
//	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateSecurityGroup";
//
//	private MessageManager bundle_messages = MessageManager.getInstance("messages");
//	
//	private boolean initialize = false;
//
//	@Override
//	protected void invoke(IAction action) throws InvocationException {
//		INetworkSecurityRoot securityGroupRoot = ((SecurityGroupsView)viewPart).getCurrentRootElement();
//		
//		CreateSecurityGroupDialog dialog = new CreateSecurityGroupDialog(this.viewPart.getSite().getShell());
//		dialog.setRegionName(securityGroupRoot.getRegion().getRegionName());
//		
//		if(dialog.open() == Window.OK){
//			if (MessageDialog.openConfirm(
//				null,
//				Messages.getString("confirmed"),
//				bundle_messages.getString("views.actions.create_security_group_confirm"))){
//				CreateSecurityGroupRequest request = new CreateSecurityGroupRequest();
//				
//				request.setSecurityGroupName(dialog.getSecurityGroupName());
//				request.setDescription(dialog.getDescription());
//				securityGroupRoot.createSecurityGroup(request);
//
//				// 成功報告ダイアログを生成
//				MessageDialog.openInformation(
//					null,
//					Messages.getString("successful"),
//					bundle_messages.getString("views.actions.create_security_group_result"));
//			}
//			else {
//				return;
//			}
//		}
//	}
//	
//	@Override
//	public void init(IViewPart view) {
//		super.init(view);
//		view.getSite().getPage().addSelectionListener(this);
//	}
//
//	@Override
//	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
//		if (!initialize) {
//			IAction action = ((ActionContributionItem)viewPart.getViewSite().getActionBars().getToolBarManager().find(ID)).getAction();
//			action.setEnabled(false);
//			initialize = true;
//		}
//
//		if (part.getSite().getId().equals(ScopeView.Id)) {
//			boolean enabled = true;
//			if (selection.isEmpty()) {
//				enabled = false;
//			}
//			else {
//				Object selected = ((IStructuredSelection)selection).getFirstElement();
//				try {
//					if (selected instanceof IScope) {
//						IScope scope = (IScope)selected;
//						switch(scope.getScopeType()) {
//						case root:
//							enabled = false;
//							break;
//						case region:
//							{
//								IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
//								ec2Service.getRegion(scope.getFacilityId());
//							}
//							break;
//						case availabilityZone:
//							{
//								IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
//								ec2Service.getRegion(scope.getParent().getFacilityId());
//							}
//							break;
//						default:
//							enabled = false;
//						}
//					}
//					else if (selected instanceof INode) {
//						INode node = (INode)selected;
//
//						IEC2Service ec2Service = Activator.getDefault().getCloudManager().getInventory().getFolder(IEC2Service.class);
//						ec2Service.getRegion(node.getParent().getParent().getFacilityId());
//					}
//				}
//				catch (Exception e) {
//					enabled = false;
//				}
//			}
//
//			IAction action = ((ActionContributionItem)viewPart.getViewSite().getActionBars().getToolBarManager().find(ID)).getAction();
//			action.setEnabled(enabled);
//		}
//	}
//}