/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.CreateTemplateJobDialog;
import com.clustercontrol.util.Messages;


public class CreateTemplateJobAction extends AbstractViewAction {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateTemplateJobAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateTemplateJobDialog dialog = new CreateTemplateJobDialog(this.viewPart.getSite().getShell());

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_template_job_confirm"))) {

				try {
					CreateTemplateJobDialog.DialogOutput output = dialog.getOutput();
					
					TemplateJobUtil.TemplateJobnet jobnet = new TemplateJobUtil.TemplateJobnet();
					
					jobnet.setJobnetId(output.getJobnetId());
					jobnet.setJobnetName(output.getJobnetName());
					jobnet.setOsType(output.getOsType());
					jobnet.setJobs(output.getTemplateJobList());
					
					TemplateJobUtil.registerJob(jobnet);
					
				} catch (Exception e) {
					throw new InvocationException(e);
				}
				
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_template_job_result"));
			}
			else {
				return;
			}
		}
	}
}