/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstance.RegistStateType;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.views.InstancesView2;
import com.clustercontrol.util.Messages;

public class DeleteInstanceAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DeleteInstanceAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	private MessageManager bundle_view_label = MessageManager.getInstance("view_label");

	@Override
	protected void invoke(IAction action) {
		IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		if (
			MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			bundle_messages.getString(
				"views.actions.delete_instance_confirm") + "\n" + bundle_view_label.getString("view.instance.column.facility_id") + " = " + instance.getFacilityId() + ", " + bundle_view_label.getString("view.instance.column.instance_id") + " = " + instance.getInstanceId()
				)
			){

			instance.getInstanceRoot().deleteInstance(instance.getInstanceId());

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.delete_instance_result"));

			final InstancesView2 view = (InstancesView2)viewPart;
			view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
				@Override
				public void run() {
					com.clustercontrol.action.FacilityTree.reflesh();
				}
			});
		}
	}

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		IInstance instance = (IInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		return !RegistStateType.deleted.equals(instance.getRegistState());
	}
}