/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import java.util.Iterator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.aws.presenter.IBillingAlarm;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;

public class DisableBillingAlarmAction extends MultiSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.DisableBillingAlarmAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	public void invoke(IAction action) {

		StringBuffer sb = new StringBuffer();
		
		Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
		int i = 0;
		while (iter.hasNext()) {
			sb.append(((IBillingAlarm)iter.next()).getAlarmId());
			if(iter.hasNext()) sb.append(", ");
			i++;
			if(i > 10){
				sb.append("\n");
				i = 0;
			}
		}
		
		if (
			MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.disable_billing_alarm_confirm")+"\n"+sb)
				) {

			iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
			while (iter.hasNext()) {
				((IBillingAlarm)iter.next()).disableAlarm();
			}

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.disable_billing_alarm_result"));
		}
	}

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).iterator();
		while (iter.hasNext()) {
			IBillingAlarm alarm = (IBillingAlarm)iter.next();
			if (alarm.getValidFlg() != null && !alarm.getValidFlg()) {
				return false;
			}
		}
		return true;
	}
}