/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;


public class FilterSecurityGroup implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.FilterSecurityGroup";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private IViewPart viewPart;

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

	@Override
	public void run(IAction action) {
		//TODO
		Dialog dialog = new Dialog(this.viewPart.getSite().getShell()){};
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				//TODO
				bundle_messages.getString("views.actions."))){
				try {
					//TODO
	
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						//TODO
						bundle_messages.getString("views.actions."));
	
				} catch (Exception e) {
					// 失敗報告ダイアログを生成
					MessageDialog.openError(
						null,
						Messages.getString("failed"),
						e.getMessage());
				}
			} else {
				return;
			}
		}
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}
}