/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CreateIdentityRequest;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IIdentityManagement;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.RegistAccountDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.access.UserInfo;


public class RegistAccountAction extends SingleSelectionActionEx {

	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RegistAccount";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	private IViewPart viewPart;

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}
	@Override
	protected void invoke(IAction action) {
		// 選択されている情報を抽出。
		IIdentity selectedIdentity = null;
		RegistAccountDialog.Type type = null;
		Object selected = ((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		if (selected instanceof IIdentity) {
			selectedIdentity = (IIdentity)selected;
			type = RegistAccountDialog.Type.user;
		}
		else if (selected instanceof ICategory) {
			type = RegistAccountDialog.Type.account;
		}

		RegistAccountDialog dialog = new RegistAccountDialog(this.viewPart.getSite().getShell(), RegistAccountDialog.Mode.regist, type);
		
		// まだ選択されていない Hinemos アカウントを抽出する。
		AccessEndpoint accessEndpoint = Activator.getEndpointManager().getEndpoint(AccessEndpoint.class);
		List<UserInfo> allHinemosUsers = null; 
		try {
			allHinemosUsers = accessEndpoint.getUserInfoList(null);
		}
		catch (Exception e) {
			throw new CloudModelException(e);
		}

		final List<IIdentity> allCloudUsers = new ArrayList<IIdentity>();
		IIdentityManagement im = Activator.getDefault().getCloudManager().getIdentityManagement();
		im.each(new IIdentityManagement.Verifier() {
			@Override
			public void velify(IIdentity element) {
				allCloudUsers.add(element);
			}
		});

		Iterator<UserInfo> userInfoIter = allHinemosUsers.iterator();
		while (userInfoIter.hasNext()) {
			UserInfo ui = userInfoIter.next();
			
			Iterator<IIdentity> cloudUserIter = allCloudUsers.iterator();
			while (cloudUserIter.hasNext()) {
				IIdentity cu = cloudUserIter.next();
				
				if (ui.getId().equals(cu.getHinemosUserId())) {
					userInfoIter.remove();
					cloudUserIter.remove();
					break;
				}
			}
		}

		// ダイアログに選択可能な Hinemos ユーザーを教える。
		if (!allHinemosUsers.isEmpty()) {
			List<String> hinemosUsers = new ArrayList<String>(); 
			for (UserInfo ui: allHinemosUsers) {
				hinemosUsers.add(ui.getId());
			}
			dialog.setUserIdList(hinemosUsers.toArray(new String[0]));
		}
		else {
			// 失敗報告ダイアログを生成
			MessageDialog.openWarning(null, Messages.getString("warning"), bundle_messages.getString("dialogs.warning.all_user_used"));
			return;
		}

		dialog.setCategory(im.getCategories()[0]);
		
		if (dialog.open() == Window.OK) {
			if (
				MessageDialog.openConfirm(null,
					Messages.getString("confirmed"),
					bundle_messages.getString("views.actions.create_user_confirm"))
				) {
				RegistAccountDialog.Model m = dialog.getOutput();
				
				CreateIdentityRequest request = new CreateIdentityRequest();
				
				request.id = m.id;
				request.name = m.name;
				request.description = m.description;
				request.key = m.key;
				request.hinemosUserId = m.hinemosUserId;

				if (selectedIdentity != null) {
					selectedIdentity.createChildIdentity(request);
				}
				else {
					m.category.createChildIdentity(request);
				}
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_user_result"));
			}
			else {
				return;
			}
		}
	}

	@Override
	protected boolean canEnabled(IStructuredSelection selection) {
		return (selection.getFirstElement() instanceof IIdentity && ((IIdentity)selection.getFirstElement()).getParent() == null) || selection.getFirstElement() instanceof ICategory;
	}
}