/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;


public class RemoveTemplateAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.ModifyTemplateAction";

	private MessageManager bundle_messages = MessageManager.getInstance("messages"); 

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ITemplate template = (ITemplate)((IStructuredSelection) this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			bundle_messages.getString("views.actions.delete_template_confirm") + "\n" +template.getTemplateId())) {

			template.getTemplateManagement().deleteTemplate(template.getTemplateId());
			
			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				bundle_messages.getString("views.actions.delete_template_result"));
		}
		else {
			return;
		}
	}
}