/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.IRegion;
import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.ui.dialogs.RestoreStorageBehavior;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;


public class RestoreStorageAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.RestoreStorage";

	private MessageManager bundle_messages = MessageManager.getInstance("messages");

	@Override
	protected void invoke(IAction action) throws InvocationException {
		CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());

		IStorageBackup backup = (IStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		String region = backup.getRegion();
		if (region != null) {
			CreateStorageDialog.Model m = new CreateStorageDialog.Model();
			m.region = region;
			m.setAvailabilityZone(backup.getAvailabilityZone());
			m.setSnapshotId(backup.getSnapshotId());
			m.setStorageName(backup.getStorageName());
			m.setStorageSize(backup.getStorageSize());
			dialog.setInput(m);
		}

		final CloudEndpoint endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
		dialog.setCloudInfoProvider(new CloudResourceProviderImpl(endpoint));
		dialog.setBehavior(new RestoreStorageBehavior(backup));
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				bundle_messages.getString("views.actions.create_storage_confirm"))){

				CreateStorageDialog.Model m = dialog.getOutput();
				IRegion r = backup.getStorageBackupRoot().getBackupManagement().getRegion();
				r.getStorageRoot().restore(m);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					bundle_messages.getString("views.actions.create_storage_result"));
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		IStorageBackup backup = (IStorageBackup)((IStructuredSelection)selection).getFirstElement();
		if(backup == null || backup.getExistsStatus() == null || backup.getExistsStatus() == IStorageBackup.ExistStatusType.nothing){
			action.setEnabled(false);
		}
	}
}