
package com.clustercontrol.ws.cloud;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.7-b01-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "CloudEndpoint", targetNamespace = "http://cloud.ws.clustercontrol.com")
@XmlSeeAlso({
    com.clustercontrol.ws.cloud.ObjectFactory.class,
    com.clustercontrol.ws.notify.ObjectFactory.class
})
public interface CloudEndpoint {


    /**
     * 
     * @param instanceId
     * @param regionName
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstance")
    @ResponseWrapper(localName = "getInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceResponse")
    public CloudInstance getInstance(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param template
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudTemplate
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddTemplate")
    @ResponseWrapper(localName = "addTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddTemplateResponse")
    public CloudTemplate addTemplate(
        @WebParam(name = "template", targetNamespace = "")
        CloudTemplate template)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "restoreInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreInstance")
    @ResponseWrapper(localName = "restoreInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreInstanceResponse")
    public CloudInstance restoreInstance(
        @WebParam(name = "request", targetNamespace = "")
        RestoreInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param region
     * @param instanceId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstance")
    @ResponseWrapper(localName = "removeInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstanceResponse")
    public void removeInstance(
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.InstanceStateChange
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "startInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StartInstance")
    @ResponseWrapper(localName = "startInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StartInstanceResponse")
    public InstanceStateChange startInstance(
        @WebParam(name = "request", targetNamespace = "")
        StartInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.InstanceStateChange
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "stopInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StopInstance")
    @ResponseWrapper(localName = "stopInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StopInstanceResponse")
    public InstanceStateChange stopInstance(
        @WebParam(name = "request", targetNamespace = "")
        StopInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param alarmId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeBillingAlarm", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveBillingAlarm")
    @ResponseWrapper(localName = "removeBillingAlarmResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveBillingAlarmResponse")
    public void removeBillingAlarm(
        @WebParam(name = "alarmId", targetNamespace = "")
        String alarmId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param billingAlarm
     * @return
     *     returns com.clustercontrol.ws.cloud.BillingAlarm
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "modifyBillingAlarm", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyBillingAlarm")
    @ResponseWrapper(localName = "modifyBillingAlarmResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyBillingAlarmResponse")
    public BillingAlarm modifyBillingAlarm(
        @WebParam(name = "billingAlarm", targetNamespace = "")
        BillingAlarm billingAlarm)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param userId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveCloudUser")
    @ResponseWrapper(localName = "removeCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveCloudUserResponse")
    public void removeCloudUser(
        @WebParam(name = "userId", targetNamespace = "")
        String userId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param cloudUser
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudUser
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "modifyCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyCloudUser")
    @ResponseWrapper(localName = "modifyCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyCloudUserResponse")
    public CloudUser modifyCloudUser(
        @WebParam(name = "cloudUser", targetNamespace = "")
        CloudUser cloudUser)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.SecurityGroup>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getSecurityGroupsByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSecurityGroupsByRegion")
    @ResponseWrapper(localName = "getSecurityGroupsByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSecurityGroupsByRegionResponse")
    public List<SecurityGroup> getSecurityGroupsByRegion(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @param filters
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.SecurityGroup>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getSecurityGroups", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSecurityGroups")
    @ResponseWrapper(localName = "getSecurityGroupsResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSecurityGroupsResponse")
    public List<SecurityGroup> getSecurityGroups(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "filters", targetNamespace = "")
        List<Filter> filters)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Region>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllRegion")
    @ResponseWrapper(localName = "getAllRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllRegionResponse")
    public List<Region> getAllRegion()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.AvailabilityZone>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAvailabilityZones", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAvailabilityZones")
    @ResponseWrapper(localName = "getAvailabilityZonesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAvailabilityZonesResponse")
    public List<AvailabilityZone> getAvailabilityZones(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @param filters
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Image>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getImages", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetImages")
    @ResponseWrapper(localName = "getImagesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetImagesResponse")
    public List<Image> getImages(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "filters", targetNamespace = "")
        List<Filter> filters)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllInstanceType", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllInstanceType")
    @ResponseWrapper(localName = "getAllInstanceTypeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllInstanceTypeResponse")
    public List<String> getAllInstanceType()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.KeyPair>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getKeyNames", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetKeyNames")
    @ResponseWrapper(localName = "getKeyNamesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetKeyNamesResponse")
    public List<KeyPair> getKeyNames(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorage
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "restoreStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreStorage")
    @ResponseWrapper(localName = "restoreStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreStorageResponse")
    public CloudStorage restoreStorage(
        @WebParam(name = "request", targetNamespace = "")
        CreateStorageRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @param storageId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorage")
    @ResponseWrapper(localName = "removeStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorageResponse")
    public void removeStorage(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param snapshotId
     * @param regionName
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeStorageBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorageBackup")
    @ResponseWrapper(localName = "removeStorageBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorageBackupResponse")
    public void removeStorageBackup(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "snapshotId", targetNamespace = "")
        String snapshotId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param imageId
     * @param regionName
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeInstanceBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstanceBackup")
    @ResponseWrapper(localName = "removeInstanceBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstanceBackupResponse")
    public void removeInstanceBackup(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "imageId", targetNamespace = "")
        String imageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @param filters
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Subnet>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getSubnets", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSubnets")
    @ResponseWrapper(localName = "getSubnetsResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSubnetsResponse")
    public List<Subnet> getSubnets(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "filters", targetNamespace = "")
        List<Filter> filters)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param instanceId
     * @param regionName
     * @return
     *     returns java.lang.String
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getWindowsPassword", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetWindowsPassword")
    @ResponseWrapper(localName = "getWindowsPasswordResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetWindowsPasswordResponse")
    public String getWindowsPassword(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @param filter
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Snapshot>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getSnapshots", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSnapshots")
    @ResponseWrapper(localName = "getSnapshotsResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSnapshotsResponse")
    public List<Snapshot> getSnapshots(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "filter", targetNamespace = "")
        List<Filter> filter)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllVolumeType", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllVolumeType")
    @ResponseWrapper(localName = "getAllVolumeTypeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllVolumeTypeResponse")
    public List<String> getAllVolumeType()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param device
     * @param instanceId
     * @param regionName
     * @param storageId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "attachStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AttachStorage")
    @ResponseWrapper(localName = "attachStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AttachStorageResponse")
    public void attachStorage(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId,
        @WebParam(name = "device", targetNamespace = "")
        String device)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param instanceId
     * @param regionName
     * @param storageId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "detachStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.DetachStorage")
    @ResponseWrapper(localName = "detachStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.DetachStorageResponse")
    public void detachStorage(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "registNode", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RegistNode")
    @ResponseWrapper(localName = "registNodeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RegistNodeResponse")
    public CloudInstance registNode(
        @WebParam(name = "request", targetNamespace = "")
        RegistNodeRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param instanceId
     * @param regionName
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "unregistNode", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.UnregistNode")
    @ResponseWrapper(localName = "unregistNodeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.UnregistNodeResponse")
    public void unregistNode(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllServiceName", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllServiceName")
    @ResponseWrapper(localName = "getAllServiceNameResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllServiceNameResponse")
    public List<String> getAllServiceName()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param template
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "modifyTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyTemplate")
    @ResponseWrapper(localName = "modifyTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyTemplateResponse")
    public void modifyTemplate(
        @WebParam(name = "template", targetNamespace = "")
        CloudTemplate template)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param templateId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveTemplate")
    @ResponseWrapper(localName = "removeTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveTemplateResponse")
    public void removeTemplate(
        @WebParam(name = "templateId", targetNamespace = "")
        String templateId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstance")
    @ResponseWrapper(localName = "addInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceResponse")
    public CloudInstance addInstance(
        @WebParam(name = "request", targetNamespace = "")
        CreateInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param arg0
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addInstanceByTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceByTemplate")
    @ResponseWrapper(localName = "addInstanceByTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceByTemplateResponse")
    public CloudInstance addInstanceByTemplate(
        @WebParam(name = "arg0", targetNamespace = "")
        CreateInstanceByTemplateRequest arg0)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudInstance>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstancesByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstancesByRegion")
    @ResponseWrapper(localName = "getInstancesByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstancesByRegionResponse")
    public List<CloudInstance> getInstancesByRegion(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param alarm
     * @return
     *     returns com.clustercontrol.ws.cloud.BillingAlarm
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addBillingAlarm", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddBillingAlarm")
    @ResponseWrapper(localName = "addBillingAlarmResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddBillingAlarmResponse")
    public BillingAlarm addBillingAlarm(
        @WebParam(name = "alarm", targetNamespace = "")
        BillingAlarm alarm)
        throws CloudManagerFault_Exception
    ;

    /**
     * 
     * @param alarmId
     * @return
     *     returns com.clustercontrol.ws.cloud.BillingAlarm
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getBillingAlarm", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetBillingAlarm")
    @ResponseWrapper(localName = "getBillingAlarmResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetBillingAlarmResponse")
    public BillingAlarm getBillingAlarm(
        @WebParam(name = "alarmId", targetNamespace = "")
        String alarmId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.BillingAlarm>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllBillingAlarm", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllBillingAlarm")
    @ResponseWrapper(localName = "getAllBillingAlarmResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllBillingAlarmResponse")
    public List<BillingAlarm> getAllBillingAlarm()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param cloudUser
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudUser
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddCloudUser")
    @ResponseWrapper(localName = "addCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddCloudUserResponse")
    public CloudUser addCloudUser(
        @WebParam(name = "cloudUser", targetNamespace = "")
        CloudUser cloudUser)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudUser>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllCloudUser")
    @ResponseWrapper(localName = "getAllCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllCloudUserResponse")
    public List<CloudUser> getAllCloudUser()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param userId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudUser
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUser")
    @ResponseWrapper(localName = "getCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUserResponse")
    public CloudUser getCloudUser(
        @WebParam(name = "userId", targetNamespace = "")
        String userId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param filters
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudUser>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudUsers", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUsers")
    @ResponseWrapper(localName = "getCloudUsersResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUsersResponse")
    public List<CloudUser> getCloudUsers(
        @WebParam(name = "filters", targetNamespace = "")
        List<Filter> filters)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudType>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllCloudType", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllCloudType")
    @ResponseWrapper(localName = "getAllCloudTypeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllCloudTypeResponse")
    public List<CloudType> getAllCloudType()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorage
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorage")
    @ResponseWrapper(localName = "addStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorageResponse")
    public CloudStorage addStorage(
        @WebParam(name = "request", targetNamespace = "")
        CreateStorageRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @param storageId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorage
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorage")
    @ResponseWrapper(localName = "getStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageResponse")
    public CloudStorage getStorage(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudStorage>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStoragesByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStoragesByRegion")
    @ResponseWrapper(localName = "getStoragesByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStoragesByRegionResponse")
    public List<CloudStorage> getStoragesByRegion(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorageBackup
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addStorageBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorageBackup")
    @ResponseWrapper(localName = "addStorageBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorageBackupResponse")
    public CloudStorageBackup addStorageBackup(
        @WebParam(name = "request", targetNamespace = "")
        CreateStorageBackupRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param snapshotId
     * @param regionName
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorageBackup
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackup")
    @ResponseWrapper(localName = "getStorageBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackupResponse")
    public CloudStorageBackup getStorageBackup(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "snapshotId", targetNamespace = "")
        String snapshotId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudStorageBackup>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageBackupsByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackupsByRegion")
    @ResponseWrapper(localName = "getStorageBackupsByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackupsByRegionResponse")
    public List<CloudStorageBackup> getStorageBackupsByRegion(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstanceBackup
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addInstanceBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceBackup")
    @ResponseWrapper(localName = "addInstanceBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceBackupResponse")
    public CloudInstanceBackup addInstanceBackup(
        @WebParam(name = "request", targetNamespace = "")
        CreateInstanceBackupRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param imageId
     * @param regionName
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstanceBackup
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstanceBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackup")
    @ResponseWrapper(localName = "getInstanceBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackupResponse")
    public CloudInstanceBackup getInstanceBackup(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName,
        @WebParam(name = "imageId", targetNamespace = "")
        String imageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param regionName
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudInstanceBackup>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstanceBackupsByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackupsByRegion")
    @ResponseWrapper(localName = "getInstanceBackupsByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackupsByRegionResponse")
    public List<CloudInstanceBackup> getInstanceBackupsByRegion(
        @WebParam(name = "regionName", targetNamespace = "")
        String regionName)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @param templateId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudTemplate
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     * @throws ValidationFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplate")
    @ResponseWrapper(localName = "getTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplateResponse")
    public CloudTemplate getTemplate(
        @WebParam(name = "templateId", targetNamespace = "")
        String templateId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception, ValidationFault_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudTemplate>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllTemplates", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllTemplates")
    @ResponseWrapper(localName = "getAllTemplatesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllTemplatesResponse")
    public List<CloudTemplate> getAllTemplates()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getTemplateScripts", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplateScripts")
    @ResponseWrapper(localName = "getTemplateScriptsResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplateScriptsResponse")
    public List<String> getTemplateScripts()
        throws CloudManagerFault_Exception
    ;

}
