/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.Filter;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.ui.dialogs.CreateInstanceDialog;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.ParameterManager;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class InstanceDetailDialog
extends Dialog {
    private static final int minStorageSize = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.minstoragesize"));
    private static final int multiply = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.multiply"));
    private static final int minIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.miniops"));
    private static final int maxIops = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.maxiops"));
    private static final int skip = Integer.parseInt(MessageManagerExt.getInstance("messages").getString("aws.iops.skip"));
    private static final Integer NUM_OF_TAGS = 9;
    private static final String IOPS_VALUE = "io1";
    private CreateInstanceDialog.Model input;
    private CreateInstanceDialog.Model output;
    private Combo shutdownBehaviour;
    private Combo type;
    private Button btnDetailedMonitoring;
    private Button btnTerminationProtection;
    private Button btnLaunchAsAnEBSOptimized;
    private org.eclipse.swt.widgets.List securityGroups;
    private Button btnDeleteOnTermination;
    private Text volumeSize;
    private Combo volumeType;
    private Combo cmbIops;
    private Text keyName;
    private Text valueName;
    private Text[] key = new Text[NUM_OF_TAGS.intValue()];
    private Text[] value = new Text[NUM_OF_TAGS.intValue()];
    private ControlDecoration ctdcIops;
    private ControlDecoration ctdcSize;
    private Decorator decorator;
    private CloudResourceProvider provider;
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strInstanceDetail = this.messages.getString("word.instance_detail");
    private String strInstanceType = this.messages.getString("word.instance_type");
    private String strShutdownBehavior = this.messages.getString("word.shutdown_behavior");
    private String strDetailedMonitoring = this.messages.getString("word.detailed_monitoring");
    private String strTerminationProtection = this.messages.getString("caption.termination_protection");
    private String strVolumeSizeUnit = this.messages.getString("word.volume_size_unit");
    private String strVolumeSize = this.messages.getString("word.volume_size");
    private String strSelectSecurityGroup = this.messages.getString("word.select_security_group");
    private String strVolumeType = this.messages.getString("word.volume_type");
    private String strDeleteOnTermination = this.messages.getString("word.delete_on_termination");
    private String strRootVolumeSettings = this.messages.getString("word.root_volume_settings");
    private String strIops = this.messages.getString("word.iops");
    private String strSecuritySettings = this.messages.getString("word.security_settings");
    private String strStorageDeviceSettings = this.messages.getString("word.storage_device_settings");
    private String strDetailedMonitoringDescription = this.messages.getString("caption.detailed_monitoring_description");
    private String strEbsOptimized = this.messages.getString("word.ebs_optimized");
    private String strTagsValue = this.messages.getString("word.tags_value");
    private String strTagsName = this.messages.getString("word.tags_name");
    private String strTagSettings = this.messages.getString("word.tag_settings");
    private String strEditInstanceDetailDialog = this.messages.getString("caption.edit_instance_detail_dialog");
    private String strEbsOptimizedDescription = this.messages.getString("caption.ebs_optimized_description");
    private String strEbsOptimizedDescriptionNoSupported = this.messages.getString("caption.ebs_optimized_description_no_supported");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private String msgIopsMustBeLessThanXTimesOfVolumeSize = this.messages.getString("message.must_grater_than_X", new String[]{Integer.toString(multiply), Integer.toString(minStorageSize)});
    private String msgAvailableIopsRange = this.messages.getString("message.iops_must_be_less_than_X_times_of_volume_size", new Object[]{Integer.toString(minIops), Integer.toString(maxIops)});
    private ParameterManager paramEbsOptimized = ParameterManager.getInstance((String)"ebs_optimized_enable_list");

    public InstanceDetailDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        GroupIdentifier sg;
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setBounds(0, 0, 596, 360);
        TabItem tbtmInstanceDetails = new TabItem(tabFolder, 0);
        tbtmInstanceDetails.setText(this.strInstanceDetail);
        Composite composite = new Composite((Composite)tabFolder, 0);
        tbtmInstanceDetails.setControl((Control)composite);
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.marginTop = 10;
        gl_composite.verticalSpacing = 20;
        composite.setLayout((Layout)gl_composite);
        Label lblType = new Label(composite, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText(this.strInstanceType + this.strSeparator);
        this.type = new Combo(composite, 8);
        GridData gd_type = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_type.widthHint = 100;
        this.type.setLayoutData((Object)gd_type);
        Label lblShutdownBehaviour = new Label(composite, 0);
        lblShutdownBehaviour.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblShutdownBehaviour.setText(this.strShutdownBehavior + this.strSeparator);
        this.shutdownBehaviour = new Combo(composite, 8);
        GridData gd_shutdownBehaviour = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_shutdownBehaviour.widthHint = 100;
        this.shutdownBehaviour.setLayoutData((Object)gd_shutdownBehaviour);
        Label lblDetailedMonitoring = new Label(composite, 0);
        lblDetailedMonitoring.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDetailedMonitoring.setText(this.strDetailedMonitoring + this.strSeparator);
        this.btnDetailedMonitoring = new Button(composite, 32);
        this.btnDetailedMonitoring.setText(this.strDetailedMonitoringDescription);
        Label lblTerminationProtection = new Label(composite, 0);
        lblTerminationProtection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTerminationProtection.setText(this.strTerminationProtection + this.strSeparator);
        this.btnTerminationProtection = new Button(composite, 32);
        Label lblLaunchAsAnEBSOptimizedInstance = new Label(composite, 0);
        lblLaunchAsAnEBSOptimizedInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLaunchAsAnEBSOptimizedInstance.setText(this.strEbsOptimized + this.strSeparator);
        this.btnLaunchAsAnEBSOptimized = new Button(composite, 32);
        composite.layout();
        TabItem tbtmModifyTags = new TabItem(tabFolder, 0);
        tbtmModifyTags.setText(this.strTagSettings);
        Composite composite_1 = new Composite((Composite)tabFolder, 0);
        tbtmModifyTags.setControl((Control)composite_1);
        GridLayout gl_composite_1 = new GridLayout(2, false);
        gl_composite_1.verticalSpacing = 2;
        composite_1.setLayout((Layout)gl_composite_1);
        Label lblKey = new Label(composite_1, 0);
        lblKey.setText(this.strTagsName + this.strSeparator);
        Label lblValue = new Label(composite_1, 0);
        lblValue.setText(this.strTagsValue + this.strSeparator);
        this.keyName = new Text(composite_1, 2048);
        this.keyName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keyName.setText("Name");
        this.keyName.setEditable(false);
        this.valueName = new Text(composite_1, 2048);
        this.valueName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.valueName.setEditable(false);
        for (int i = 0; i < NUM_OF_TAGS; ++i) {
            this.key[i] = new Text(composite_1, 2048);
            this.key[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.value[i] = new Text(composite_1, 2048);
            this.value[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        composite_1.layout();
        TabItem tbtmSecuritySettigns = new TabItem(tabFolder, 0);
        tbtmSecuritySettigns.setText(this.strSecuritySettings);
        Composite composite_2 = new Composite((Composite)tabFolder, 0);
        tbtmSecuritySettigns.setControl((Control)composite_2);
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.marginTop = 10;
        gl_composite_2.verticalSpacing = 10;
        composite_2.setLayout((Layout)gl_composite_2);
        Group group_1 = new Group(composite_2, 0);
        group_1.setLayout((Layout)new GridLayout(1, false));
        GridData gd_group_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_group_1.heightHint = 187;
        gd_group_1.widthHint = 572;
        group_1.setLayoutData((Object)gd_group_1);
        group_1.setText(this.strSelectSecurityGroup + this.strSeparator);
        this.securityGroups = new org.eclipse.swt.widgets.List((Composite)group_1, 2562);
        GridData gd_securityGroups = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_securityGroups.heightHint = 172;
        gd_securityGroups.widthHint = 539;
        this.securityGroups.setLayoutData((Object)gd_securityGroups);
        this.securityGroups.select(0);
        TabItem tbtmStorageDeviceConfiguration = new TabItem(tabFolder, 0);
        tbtmStorageDeviceConfiguration.setText(this.strStorageDeviceSettings);
        Composite composite_4 = new Composite((Composite)tabFolder, 0);
        tbtmStorageDeviceConfiguration.setControl((Control)composite_4);
        GridLayout gl_composite_4 = new GridLayout(1, false);
        gl_composite_4.marginTop = 10;
        gl_composite_4.verticalSpacing = 20;
        composite_4.setLayout((Layout)gl_composite_4);
        Group group = new Group(composite_4, 0);
        GridLayout gl_group = new GridLayout(3, false);
        gl_group.horizontalSpacing = 15;
        group.setLayout((Layout)gl_group);
        GridData gd_group = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_group.widthHint = 569;
        group.setLayoutData((Object)gd_group);
        group.setText(this.strRootVolumeSettings + this.strSeparator);
        Label lblVolumeSize = new Label((Composite)group, 0);
        lblVolumeSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeSize.setText(this.strVolumeSize + this.strSeparator);
        this.volumeSize = new Text((Composite)group, 2048);
        this.volumeSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.ctdcSize = new ControlDecoration((Control)this.volumeSize, 16512);
        this.ctdcSize.setImage(ResourceManager.getPluginImage((String)Activator.ID, (String)"icons/error.gif"));
        this.ctdcSize.setDescriptionText("");
        this.ctdcSize.hide();
        Label lblGib = new Label((Composite)group, 0);
        lblGib.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblGib.setText(this.strVolumeSizeUnit);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label lblVolumeType = new Label((Composite)group, 0);
        lblVolumeType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeType.setText(this.strVolumeType + this.strSeparator);
        this.volumeType = new Combo((Composite)group, 8);
        GridData gd_volumeType = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_volumeType.widthHint = 100;
        this.volumeType.setLayoutData((Object)gd_volumeType);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label lblIops = new Label((Composite)group, 0);
        lblIops.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIops.setText(this.strIops + this.strSeparator);
        this.cmbIops = new Combo((Composite)group, 2048);
        GridData gd_cmbIops = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_cmbIops.widthHint = 100;
        this.cmbIops.setLayoutData((Object)gd_cmbIops);
        this.cmbIops.setEnabled(false);
        this.ctdcIops = new ControlDecoration((Control)this.cmbIops, 16512);
        this.ctdcIops.setImage(ResourceManager.getPluginImage((String)Activator.ID, (String)"icons/error.gif"));
        this.ctdcIops.hide();
        this.cmbIops.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.keyCode >= 48 && e.keyCode <= 57 && e.stateMask == 0 || e.keyCode >= 0x1000030 && e.keyCode <= 16777273 && e.stateMask == 0 || InstanceDetailDialog.checkKey(e.keyCode))) {
                    e.doit = false;
                }
            }
        });
        this.cmbIops.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstanceDetailDialog.this.checkIops();
            }
        });
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label lblDeleteOnTermination = new Label((Composite)group, 0);
        lblDeleteOnTermination.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDeleteOnTermination.setText(this.strDeleteOnTermination + this.strSeparator);
        this.btnDeleteOnTermination = new Button((Composite)group, 32);
        this.btnDeleteOnTermination.setSelection(true);
        new Label((Composite)group, 0);
        List<String> instanceTypes = this.provider.getAllInstanceType();
        for (String it : instanceTypes) {
            String itemName = it + " (" + this.messages.getString(it) + ")";
            this.type.add(itemName);
            this.type.setData(itemName, (Object)it);
        }
        if (!instanceTypes.isEmpty()) {
            this.type.select(0);
            this.checkEbsOptimized();
        }
        this.shutdownBehaviour.add("stop");
        this.shutdownBehaviour.add("terminate");
        this.shutdownBehaviour.select(0);
        List<Object> sgs = Collections.emptyList();
        if (this.input.getSubnet() != null) {
            sgs = this.provider.getSecurityGroups(this.input.getRegionName(), Arrays.asList(new Filter("vpc-id", Arrays.asList(this.input.getSubnet().getVpcId()))));
        } else {
            sgs = new ArrayList<GroupIdentifier>(this.provider.getSecurityGroupsByRegion(this.input.getRegionName()));
            Iterator iter = sgs.iterator();
            while (iter.hasNext()) {
                sg = (GroupIdentifier)iter.next();
                if (sg.getVpcId() == null) continue;
                iter.remove();
            }
        }
        for (int i = 0; i < sgs.size(); ++i) {
            sg = (GroupIdentifier)sgs.get(i);
            this.securityGroups.add(sg.getGroupName());
            this.securityGroups.setData(Integer.toString(i), (Object)sg);
        }
        for (String volumeTypeName : this.provider.getAllVolumeType()) {
            String volumeTypeLocaleName = this.messages.getString(volumeTypeName);
            this.volumeType.add(volumeTypeLocaleName);
            this.volumeType.setData(volumeTypeLocaleName, (Object)volumeTypeName);
        }
        this.volumeType.select(0);
        if (this.input != null) {
            if (this.input.getFlavor() != null) {
                String itemName = this.input.getFlavor() + " (" + this.messages.getString(this.input.getFlavor()) + ")";
                this.type.setText(itemName);
                this.checkEbsOptimized();
            }
            if (this.input.getInstanceInitiatedShutdownBehavior() != null) {
                this.shutdownBehaviour.setText(this.input.getInstanceInitiatedShutdownBehavior());
            }
            if (this.input.getMonitoring() != null) {
                this.btnDetailedMonitoring.setSelection(this.input.getMonitoring().booleanValue());
            }
            if (this.input.getDisableApiTermination() != null) {
                this.btnTerminationProtection.setSelection(this.input.getDisableApiTermination().booleanValue());
            }
            if (this.input.getFacilityName() != null) {
                this.valueName.setText(this.input.getFacilityName());
            }
            if (this.input.getSecurityGroups() != null) {
                ArrayList<Integer> selections = new ArrayList<Integer>();
                int size = this.securityGroups.getItems().length;
                block5: for (int i = 0; i < size; ++i) {
                    GroupIdentifier selectable = (GroupIdentifier)this.securityGroups.getData(Integer.toString(i));
                    for (GroupIdentifier sg2 : this.input.getSecurityGroups()) {
                        if (!selectable.getGroupId().equals(sg2.getGroupId())) continue;
                        selections.add(i);
                        continue block5;
                    }
                }
                int[] indices = new int[selections.size()];
                for (int i = 0; i < selections.size(); ++i) {
                    indices[i] = (Integer)selections.get(i);
                }
                this.securityGroups.select(indices);
            }
            if (this.input.getEbsOptimized() != null) {
                this.btnLaunchAsAnEBSOptimized.setSelection(this.input.getEbsOptimized().booleanValue());
            }
            if (this.input.getTags() != null && !this.input.getTags().isEmpty()) {
                int i = 0;
                for (Tag tag : this.input.getTags()) {
                    this.key[i].setText(tag.name);
                    this.value[i].setText(tag.value);
                    ++i;
                }
            }
            if (this.input.getRootBlockDevice() != null) {
                if (this.input.getRootBlockDevice().volumeSize != null) {
                    this.volumeSize.setText(this.input.getRootBlockDevice().volumeSize.toString());
                }
                if (this.input.getRootBlockDevice().volumeType != null) {
                    this.volumeType.setText(this.messages.getString(this.input.getRootBlockDevice().volumeType));
                }
                if (this.input.getRootBlockDevice().iops != null) {
                    this.cmbIops.setText(this.input.getRootBlockDevice().iops.toString());
                }
                if (this.input.getRootBlockDevice().deleteOnTermination != null) {
                    this.btnDeleteOnTermination.setSelection(this.input.getRootBlockDevice().deleteOnTermination.booleanValue());
                }
                if (this.messages.getString(IOPS_VALUE).equals(this.volumeType.getText())) {
                    this.cmbIops.setEnabled(true);
                    if (!"".equals(this.volumeSize.getText())) {
                        String n = this.cmbIops.getText();
                        this.cmbIops.removeAll();
                        for (int iops = skip; iops <= maxIops; iops += skip) {
                            this.cmbIops.add(Integer.toString(iops));
                        }
                        this.cmbIops.setText(n);
                    }
                }
                this.checkIops();
            }
        }
        this.type.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceDetailDialog.this.checkEbsOptimized();
            }
        });
        this.volumeType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (InstanceDetailDialog.this.volumeType.getText().equals(InstanceDetailDialog.this.messages.getString(InstanceDetailDialog.IOPS_VALUE))) {
                    InstanceDetailDialog.this.cmbIops.setEnabled(true);
                    InstanceDetailDialog.this.decorator.setEnabled(true);
                } else {
                    InstanceDetailDialog.this.decorator.setEnabled(false);
                    InstanceDetailDialog.this.cmbIops.setEnabled(false);
                }
                InstanceDetailDialog.this.checkIops();
            }
        });
        ControlUtil.setInputRestriction((Control[])new Control[]{this.volumeSize, this.cmbIops}, (Pattern)Pattern.compile("^[0-9]+$"));
        this.volumeSize.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!"".equals(InstanceDetailDialog.this.volumeSize.getText())) {
                    String n = InstanceDetailDialog.this.cmbIops.getText();
                    InstanceDetailDialog.this.cmbIops.removeAll();
                    for (int iops = skip; iops <= maxIops; iops += skip) {
                        InstanceDetailDialog.this.cmbIops.add(Integer.toString(iops));
                    }
                    InstanceDetailDialog.this.cmbIops.setText(n);
                }
            }
        });
        this.volumeSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstanceDetailDialog.this.checkIops();
            }
        });
        this.decorator = new Decorator(this.cmbIops);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        int[] indices;
        if (IOPS_VALUE.equals(this.volumeType.getData(this.volumeType.getText())) && (this.volumeSize.getText().isEmpty() || this.cmbIops.getText().isEmpty())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.output = this.input != null ? this.input.deepCopy() : new CreateInstanceDialog.Model();
        this.output.setFlavor((String)this.type.getData(this.type.getText()));
        this.output.setInstanceInitiatedShutdownBehavior(this.shutdownBehaviour.getText());
        this.output.setMonitoring(this.btnDetailedMonitoring.getSelection());
        this.output.setDisableApiTermination(this.btnTerminationProtection.getSelection());
        this.output.setEbsOptimized(this.btnLaunchAsAnEBSOptimized.getSelection());
        this.output.setSecurityGroups(new ArrayList<GroupIdentifier>());
        for (int index : indices = this.securityGroups.getSelectionIndices()) {
            this.output.getSecurityGroups().add((GroupIdentifier)this.securityGroups.getData(Integer.toString(index)));
        }
        this.output.setTags(new ArrayList());
        for (int i = 0; i < NUM_OF_TAGS; ++i) {
            if (this.key[i].getText().equals("")) continue;
            Tag tag = new Tag();
            tag.name = this.key[i].getText();
            tag.value = this.value[i].getText();
            this.output.getTags().add(tag);
        }
        this.output.setRootBlockDevice(new CreateInstanceDialog.EbsBlockDevice());
        if (!this.volumeSize.getText().isEmpty()) {
            this.output.getRootBlockDevice().volumeSize = Integer.parseInt(this.volumeSize.getText());
        }
        this.output.getRootBlockDevice().volumeType = (String)this.volumeType.getData(this.volumeType.getText());
        if (!this.cmbIops.getText().equals("")) {
            this.output.getRootBlockDevice().iops = Integer.parseInt(this.cmbIops.getText());
        }
        this.output.getRootBlockDevice().deleteOnTermination = this.btnDeleteOnTermination.getSelection();
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strEditInstanceDetailDialog);
    }

    public void setInput(CreateInstanceDialog.Model input) {
        assert (input != null);
        this.input = input;
    }

    public CreateInstanceDialog.Model getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    private static boolean checkKey(int keyCode) {
        int[] keys;
        for (int key : keys = new int[]{131072, 65536, 0x1000002, 0x1000003, 0x1000004, 0x1000001, 8, 262144, 262144, 127, 27, 0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015}) {
            if (keyCode != key) continue;
            return true;
        }
        return false;
    }

    public void checkIops() {
        if (this.messages.getString(IOPS_VALUE).equals(this.volumeType.getText()) && (this.cmbIops.getText().isEmpty() || Integer.parseInt(this.cmbIops.getText()) < minIops || Integer.parseInt(this.cmbIops.getText()) > maxIops)) {
            this.ctdcIops.show();
            this.ctdcIops.setShowHover(true);
            this.ctdcIops.setDescriptionText(this.msgAvailableIopsRange);
            this.ctdcIops.showHoverText(this.msgAvailableIopsRange);
        } else {
            this.ctdcIops.hide();
            this.ctdcIops.setDescriptionText("");
            this.ctdcIops.showHoverText("");
            this.ctdcIops.setShowHover(false);
        }
        if (this.messages.getString(IOPS_VALUE).equals(this.volumeType.getText()) && (this.volumeSize.getText().isEmpty() && !this.cmbIops.getText().isEmpty() || !this.volumeSize.getText().isEmpty() && !this.cmbIops.getText().isEmpty() && Integer.parseInt(this.volumeSize.getText()) * multiply < Integer.parseInt(this.cmbIops.getText()) || Integer.parseInt(this.volumeSize.getText()) < minStorageSize)) {
            this.ctdcSize.show();
            this.ctdcSize.setShowHover(true);
            this.ctdcSize.setDescriptionText(this.msgIopsMustBeLessThanXTimesOfVolumeSize);
            this.ctdcSize.showHoverText(this.msgIopsMustBeLessThanXTimesOfVolumeSize);
        } else {
            this.ctdcSize.hide();
            this.ctdcSize.setDescriptionText("");
            this.ctdcSize.showHoverText("");
            this.ctdcSize.setShowHover(false);
        }
        if (this.messages.getString(IOPS_VALUE).equals(this.volumeType.getText())) {
            if (this.volumeSize.getText().equals("")) {
                this.volumeSize.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
            } else {
                this.volumeSize.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }

    private void checkEbsOptimized() {
        if (this.paramEbsOptimized.getList().contains(this.type.getData(this.type.getText()))) {
            this.btnLaunchAsAnEBSOptimized.setEnabled(true);
            this.btnLaunchAsAnEBSOptimized.setText(this.strEbsOptimizedDescription);
        } else {
            this.btnLaunchAsAnEBSOptimized.setEnabled(false);
            this.btnLaunchAsAnEBSOptimized.setSelection(false);
            this.btnLaunchAsAnEBSOptimized.setText(this.strEbsOptimizedDescriptionNoSupported);
        }
        this.btnLaunchAsAnEBSOptimized.getParent().layout();
    }

    public static class Decorator {
        private Combo control;
        private static ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Combo)e.getSource()).getText().equals("")) {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        };

        public Decorator(Combo control) {
            this.control = control;
            this.setEnabled(false);
        }

        public void setEnabled(boolean enable) {
            if (enable) {
                if (this.control.getText().equals("")) {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.control.addModifyListener(modifyListener);
            } else {
                this.control.removeModifyListener(modifyListener);
                this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }
}

