/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.ui.dialogs.DetachStorageFromInstanceDialog;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DetachStorageFromInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgDetachStorageConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.detach"});
    private String msgDetachStorageResult = this.messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.detach"});

    protected void invoke(IAction action) throws InvocationException {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        DetachStorageFromInstanceDialog dialog = new DetachStorageFromInstanceDialog(this.viewPart.getSite().getShell(), instance);
        if (dialog.open() == 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            Iterator<String> iter = dialog.getVolumes().iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (iter.hasNext()) {
                    sb.append(", ");
                }
                if (++i <= 10) continue;
                sb.append("\n");
                i = 0;
            }
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgDetachStorageConfirm + "\n" + sb))) {
                for (String vol : dialog.getVolumes()) {
                    instance.detachStorage(vol);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgDetachStorageResult);
            } else {
                return;
            }
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name());
    }
}

